// PocketIrkedDlg.cpp : implementation file
//

#include "stdafx.h"
#include "globals.h"
#include "PocketIrked.h"
#include "PocketIrkedDlg.h"
#include "about.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPocketIrkedDlg dialog

CPocketIrkedDlg::CPocketIrkedDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPocketIrkedDlg::IDD, pParent)
{
	short x,y;
	CPocketIrkedApp *theApp=(CPocketIrkedApp*)AfxGetApp();

	//{{AFX_DATA_INIT(CPocketIrkedDlg)
	m_strCount = _T("");
	m_strLevel = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = theApp->LoadIcon(IDR_MAINFRAME);
	m_ptOffset=CPoint(10,15);
	m_pBlock[0][0]=&m_Tile00;
	m_pBlock[0][1]=&m_Tile01;
	m_pBlock[0][2]=&m_Tile02;
	m_pBlock[0][3]=&m_Tile03;
	m_pBlock[0][4]=&m_Tile04;
	m_pBlock[0][5]=&m_Tile05;
	m_pBlock[0][6]=&m_Tile06;
	m_pBlock[0][7]=&m_Tile07;
	m_pBlock[0][8]=&m_Tile08;
	m_pBlock[0][9]=&m_Tile09;
	m_pBlock[1][0]=&m_Tile10;
	m_pBlock[1][1]=&m_Tile11;
	m_pBlock[1][2]=&m_Tile12;
	m_pBlock[1][3]=&m_Tile13;
	m_pBlock[1][4]=&m_Tile14;
	m_pBlock[1][5]=&m_Tile15;
	m_pBlock[1][6]=&m_Tile16;
	m_pBlock[1][7]=&m_Tile17;
	m_pBlock[1][8]=&m_Tile18;
	m_pBlock[1][9]=&m_Tile19;
	m_pBlock[2][0]=&m_Tile20;
	m_pBlock[2][1]=&m_Tile21;
	m_pBlock[2][2]=&m_Tile22;
	m_pBlock[2][3]=&m_Tile23;
	m_pBlock[2][4]=&m_Tile24;
	m_pBlock[2][5]=&m_Tile25;
	m_pBlock[2][6]=&m_Tile26;
	m_pBlock[2][7]=&m_Tile27;
	m_pBlock[2][8]=&m_Tile28;
	m_pBlock[2][9]=&m_Tile29;
	m_pBlock[3][0]=&m_Tile30;
	m_pBlock[3][1]=&m_Tile31;
	m_pBlock[3][2]=&m_Tile32;
	m_pBlock[3][3]=&m_Tile33;
	m_pBlock[3][4]=&m_Tile34;
	m_pBlock[3][5]=&m_Tile35;
	m_pBlock[3][6]=&m_Tile36;
	m_pBlock[3][7]=&m_Tile37;
	m_pBlock[3][8]=&m_Tile38;
	m_pBlock[3][9]=&m_Tile39;
	m_pBlock[4][0]=&m_Tile40;
	m_pBlock[4][1]=&m_Tile41;
	m_pBlock[4][2]=&m_Tile42;
	m_pBlock[4][3]=&m_Tile43;
	m_pBlock[4][4]=&m_Tile44;
	m_pBlock[4][5]=&m_Tile45;
	m_pBlock[4][6]=&m_Tile46;
	m_pBlock[4][7]=&m_Tile47;
	m_pBlock[4][8]=&m_Tile48;
	m_pBlock[4][9]=&m_Tile49;
	m_pBlock[5][0]=&m_Tile50;
	m_pBlock[5][1]=&m_Tile51;
	m_pBlock[5][2]=&m_Tile52;
	m_pBlock[5][3]=&m_Tile53;
	m_pBlock[5][4]=&m_Tile54;
	m_pBlock[5][5]=&m_Tile55;
	m_pBlock[5][6]=&m_Tile56;
	m_pBlock[5][7]=&m_Tile57;
	m_pBlock[5][8]=&m_Tile58;
	m_pBlock[5][9]=&m_Tile59;
	m_pBlock[6][0]=&m_Tile60;
	m_pBlock[6][1]=&m_Tile61;
	m_pBlock[6][2]=&m_Tile62;
	m_pBlock[6][3]=&m_Tile63;
	m_pBlock[6][4]=&m_Tile64;
	m_pBlock[6][5]=&m_Tile65;
	m_pBlock[6][6]=&m_Tile66;
	m_pBlock[6][7]=&m_Tile67;
	m_pBlock[6][8]=&m_Tile68;
	m_pBlock[6][9]=&m_Tile69;
	m_pBlock[7][0]=&m_Tile70;
	m_pBlock[7][1]=&m_Tile71;
	m_pBlock[7][2]=&m_Tile72;
	m_pBlock[7][3]=&m_Tile73;
	m_pBlock[7][4]=&m_Tile74;
	m_pBlock[7][5]=&m_Tile75;
	m_pBlock[7][6]=&m_Tile76;
	m_pBlock[7][7]=&m_Tile77;
	m_pBlock[7][8]=&m_Tile78;
	m_pBlock[7][9]=&m_Tile79;

	m_bmBlock[0].LoadBitmap(IDB_TILE0);
	m_bmBlock[1].LoadBitmap(IDB_TILE1);
	m_bmBlock[2].LoadBitmap(IDB_TILE2);
	m_bmBlock[3].LoadBitmap(IDB_TILE3);
	m_bmBlock[4].LoadBitmap(IDB_TILE4);
	m_bmBlock[5].LoadBitmap(IDB_TILE5);
	m_bmBlock[6].LoadBitmap(IDB_TILE6);
	m_bmBlock[7].LoadBitmap(IDB_TILE7);
	m_bmBlock[8].LoadBitmap(IDB_TILE8);
	m_bmBlock[9].LoadBitmap(IDB_TILE9);

	
	m_iLevel=theApp->GetProfileInt(CString("Irked"),CString("level"),1);
	if(!m_iLevel)
		m_iLevel=1;
	for(x=0;x<11;x++)
		for(y=0;y<9;y++)
			current[y][x]=level[m_iLevel-1][y][x];

}

void CPocketIrkedDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPocketIrkedDlg)
	DDX_Control(pDX, IDC_FIRST, m_First);
	DDX_Control(pDX, IDC_LAST, m_Last);
	DDX_Control(pDX, IDC_NEXT, m_Next);
	DDX_Control(pDX, IDC_PREV, m_Prev);
	DDX_Control(pDX, IDC_RELOAD, m_Reload);
	DDX_Control(pDX, IDC_00, m_Tile00);
	DDX_Control(pDX, IDC_01, m_Tile01);
	DDX_Control(pDX, IDC_02, m_Tile02);
	DDX_Control(pDX, IDC_03, m_Tile03);
	DDX_Control(pDX, IDC_04, m_Tile04);
	DDX_Control(pDX, IDC_05, m_Tile05);
	DDX_Control(pDX, IDC_06, m_Tile06);
	DDX_Control(pDX, IDC_07, m_Tile07);
	DDX_Control(pDX, IDC_08, m_Tile08);
	DDX_Control(pDX, IDC_09, m_Tile09);
	DDX_Control(pDX, IDC_10, m_Tile10);
	DDX_Control(pDX, IDC_11, m_Tile11);
	DDX_Control(pDX, IDC_12, m_Tile12);
	DDX_Control(pDX, IDC_13, m_Tile13);
	DDX_Control(pDX, IDC_14, m_Tile14);
	DDX_Control(pDX, IDC_15, m_Tile15);
	DDX_Control(pDX, IDC_16, m_Tile16);
	DDX_Control(pDX, IDC_17, m_Tile17);
	DDX_Control(pDX, IDC_18, m_Tile18);
	DDX_Control(pDX, IDC_19, m_Tile19);
	DDX_Control(pDX, IDC_20, m_Tile20);
	DDX_Control(pDX, IDC_21, m_Tile21);
	DDX_Control(pDX, IDC_22, m_Tile22);
	DDX_Control(pDX, IDC_23, m_Tile23);
	DDX_Control(pDX, IDC_24, m_Tile24);
	DDX_Control(pDX, IDC_25, m_Tile25);
	DDX_Control(pDX, IDC_26, m_Tile26);
	DDX_Control(pDX, IDC_27, m_Tile27);
	DDX_Control(pDX, IDC_28, m_Tile28);
	DDX_Control(pDX, IDC_29, m_Tile29);
	DDX_Control(pDX, IDC_30, m_Tile30);
	DDX_Control(pDX, IDC_31, m_Tile31);
	DDX_Control(pDX, IDC_32, m_Tile32);
	DDX_Control(pDX, IDC_33, m_Tile33);
	DDX_Control(pDX, IDC_34, m_Tile34);
	DDX_Control(pDX, IDC_35, m_Tile35);
	DDX_Control(pDX, IDC_36, m_Tile36);
	DDX_Control(pDX, IDC_37, m_Tile37);
	DDX_Control(pDX, IDC_38, m_Tile38);
	DDX_Control(pDX, IDC_39, m_Tile39);
	DDX_Control(pDX, IDC_40, m_Tile40);
	DDX_Control(pDX, IDC_41, m_Tile41);
	DDX_Control(pDX, IDC_42, m_Tile42);
	DDX_Control(pDX, IDC_43, m_Tile43);
	DDX_Control(pDX, IDC_44, m_Tile44);
	DDX_Control(pDX, IDC_45, m_Tile45);
	DDX_Control(pDX, IDC_46, m_Tile46);
	DDX_Control(pDX, IDC_47, m_Tile47);
	DDX_Control(pDX, IDC_48, m_Tile48);
	DDX_Control(pDX, IDC_49, m_Tile49);
	DDX_Control(pDX, IDC_50, m_Tile50);
	DDX_Control(pDX, IDC_51, m_Tile51);
	DDX_Control(pDX, IDC_52, m_Tile52);
	DDX_Control(pDX, IDC_53, m_Tile53);
	DDX_Control(pDX, IDC_54, m_Tile54);
	DDX_Control(pDX, IDC_55, m_Tile55);
	DDX_Control(pDX, IDC_56, m_Tile56);
	DDX_Control(pDX, IDC_57, m_Tile57);
	DDX_Control(pDX, IDC_58, m_Tile58);
	DDX_Control(pDX, IDC_59, m_Tile59);
	DDX_Control(pDX, IDC_60, m_Tile60);
	DDX_Control(pDX, IDC_61, m_Tile61);
	DDX_Control(pDX, IDC_62, m_Tile62);
	DDX_Control(pDX, IDC_63, m_Tile63);
	DDX_Control(pDX, IDC_64, m_Tile64);
	DDX_Control(pDX, IDC_65, m_Tile65);
	DDX_Control(pDX, IDC_66, m_Tile66);
	DDX_Control(pDX, IDC_67, m_Tile67);
	DDX_Control(pDX, IDC_68, m_Tile68);
	DDX_Control(pDX, IDC_69, m_Tile69);
	DDX_Control(pDX, IDC_70, m_Tile70);
	DDX_Control(pDX, IDC_71, m_Tile71);
	DDX_Control(pDX, IDC_72, m_Tile72);
	DDX_Control(pDX, IDC_73, m_Tile73);
	DDX_Control(pDX, IDC_74, m_Tile74);
	DDX_Control(pDX, IDC_75, m_Tile75);
	DDX_Control(pDX, IDC_76, m_Tile76);
	DDX_Control(pDX, IDC_77, m_Tile77);
	DDX_Control(pDX, IDC_78, m_Tile78);
	DDX_Control(pDX, IDC_79, m_Tile79);
	DDX_Text(pDX, IDC_COUNT, m_strCount);
	DDX_Text(pDX, IDC_LEVEL, m_strLevel);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPocketIrkedDlg, CDialog)
	//{{AFX_MSG_MAP(CPocketIrkedDlg)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPocketIrkedDlg message handlers

BOOL CPocketIrkedDlg::OnInitDialog()
{
	CRect rc;
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// TODO: Add extra initialization here
	DoPaint();

	GetWindowRect(rc);
	m_First.GetWindowRect(m_rcFirst);
	m_rcFirst-=rc.TopLeft();
	m_Last.GetWindowRect(m_rcLast);
	m_rcLast-=rc.TopLeft();
	m_Next.GetWindowRect(m_rcNext);
	m_rcNext-=rc.TopLeft();
	m_Prev.GetWindowRect(m_rcPrev);
	m_rcPrev-=rc.TopLeft();
	m_Reload.GetWindowRect(m_rcReload);
	m_rcReload-=rc.TopLeft();

	return TRUE;  // return TRUE  unless you set the focus to a control
}




void CPocketIrkedDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CDialog::OnLButtonDown(nFlags, point);

	m_ptDown=(point-m_ptOffset);
	m_ptDown.x/=16;
	m_ptDown.y/=16;

	if(m_ptDown.y>9 || m_ptDown.x>8 || m_ptDown.y<0 || m_ptDown.x<0)
		return;
	/***
	CString strMsg;
	strMsg.Format(TEXT("%d,%d"),m_ptDown.x,m_ptDown.y);
	MessageBox(strMsg);
	***/

}

void CPocketIrkedDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CPocketIrkedApp *theApp=(CPocketIrkedApp*)AfxGetApp();
	int x, y;
	int moved;
	int mark [9][11]; // array for holding blocks marked for removal

	CDialog::OnLButtonUp(nFlags, point);

	if(m_rcFirst.PtInRect(point))
	{
		OnFirst();
	}
	else if(m_rcNext.PtInRect(point))
	{
		OnNext();
	}
	else if(m_rcReload.PtInRect(point))
	{
		OnReload();
	}
	else if(m_rcPrev.PtInRect(point))
	{
		OnPrev();
	}
	else if(m_rcLast.PtInRect(point))
	{
		OnLast();
	}
	else
	{
		x=(point.x-m_ptOffset.y)/(16);
		y=(point.y-m_ptOffset.x)/(16);

		if(m_ptDown.y>9 || m_ptDown.x>8 || m_ptDown.y<0 || m_ptDown.x<0)
			return;
		/***
		CString strMsg;
		strMsg.Format(TEXT("%d,%d->%d,%d"),m_ptDown.x,m_ptDown.y,x,y);
		MessageBox(strMsg);
		***/

		// if a block was moved to the left or right
		if((y == m_ptDown.y) && ((x == m_ptDown.x+1) || (x == m_ptDown.x-1)))
		{
			if(current[y][x] == 0)
			{
				// move block
				current[y][x] = current[m_ptDown.y][m_ptDown.x];
				current[m_ptDown.y][m_ptDown.x]=0;
				DoPaint();
				//m_pBlock[m_ptDown.y][m_ptDown.x]->SetBitmap(m_bmBlock[current[m_ptDown.y][m_ptDown.x]]);
				//m_pBlock[y][x]->SetBitmap(m_bmBlock[current[y][x]]);
			}
		
		// fall blocks
			
			do
			{
				do
				{
					moved=FALSE;
					for(x=0;x<10;x++)
					{
						for(y=6;y>=0;y--)
						{
							if((current[y][x] != 9) && (current[y][x] != 0) && current[y+1][x] == 0)
							{
								current[y+1][x]=current[y][x];
								current[y][x]=0;
								moved=TRUE;
								DoPaint();
								//m_pBlock[y][x]->SetBitmap(m_bmBlock[current[y][x]]);
								//m_pBlock[y+1][x]->SetBitmap(m_bmBlock[current[y+1][x]]);
							}
						}
					}
				}while(moved);

				// knock out blocks

				// This SEGMENT taken directly from VEXED 
				// James McCombe
				// cybertube@earthling.net
				// http://spacetube.tsx.org

				// just go through from top to bottom marking pieces which have matches above, below, left and to the right of them
				for (y = 0; y<8; y++)
				{
					for (x = 0; x<10; x++)
					{
						mark[y][x] = 0; // ALWAYS initialise each element in the 'mark' array
						if (!((current[y][x] == 0) || (current[y][x] == 9))) // only check if its not air or a wall block
						{
							mark[y][x] |= (current[y - 1][x] == current[y][x]); // if there is an identical piece above then mark this piece
							mark[y][x] |= (current[y + 1][x] == current[y][x]); // if there is an identical piece below then mark this piece
							mark[y][x] |= (current[y][x + 1] == current[y][x]); // if there is an identical piece to the right then mark this piece
							mark[y][x] |= (current[y][x - 1] == current[y][x]); // if there is an identical piece to the left then mark this piece
						}
					}
				}
				// END SEGMENT
		

			// go through the current level array checking if a piece is marked and if so, remove it
			for (y = 0; y <= 7; y ++)
				for (x = 0; x <= 9; x ++)
					if (mark[y][x])
					{
						m_iCount--;
						current[y][x]=0;
						m_pBlock[y][x]->SetBitmap(m_bmBlock[current[y][x]]);
						moved=TRUE;
					}
			}while(moved);
		}
		

		if(m_iCount == 0)
		{
			BOOL ret=theApp->WriteProfileInt(CString("Irked"),CString("level"),m_iLevel+1);
			DWORD dw=GetLastError();
			OnNext();
		}
	}
}

void CPocketIrkedDlg::OnFirst() 
{
		int x,y; 

		m_iLevel=1;
		for(x=0;x<11;x++)
			for(y=0;y<9;y++)
				current[y][x]=level[m_iLevel-1][y][x];
		DoPaint();
}

void CPocketIrkedDlg::OnPrev() 
{
		int x,y; 

		m_iLevel--;
		if(m_iLevel<1)
			m_iLevel=1;
		for(x=0;x<11;x++)
			for(y=0;y<9;y++)
				current[y][x]=level[m_iLevel-1][y][x];
		DoPaint();
	
}

void CPocketIrkedDlg::OnReload() 
{
		int x,y; 


		for(x=0;x<11;x++)
			for(y=0;y<9;y++)
				current[y][x]=level[m_iLevel-1][y][x];
		DoPaint();
	
	
}

void CPocketIrkedDlg::OnNext() 
{
	CPocketIrkedApp *theApp=(CPocketIrkedApp*)AfxGetApp();
	int x,y; 

	int m_iMax=theApp->GetProfileInt(CString("Irked"),CString("level"),1);
	m_iLevel++;
	if(m_iLevel>m_iMax)
		m_iLevel=m_iMax;
	for(x=0;x<11;x++)
		for(y=0;y<9;y++)
			current[y][x]=level[m_iLevel-1][y][x];
	DoPaint();
}

void CPocketIrkedDlg::OnLast() 
{
	CPocketIrkedApp *theApp=(CPocketIrkedApp*)AfxGetApp();
	int x,y; 

	m_iLevel=theApp->GetProfileInt(CString("Irked"),CString("level"),1);
	if(m_iLevel>59)
		m_iLevel=59;
	for(x=0;x<11;x++)
		for(y=0;y<9;y++)
			current[y][x]=level[m_iLevel-1][y][x];
	DoPaint();
}

void CPocketIrkedDlg::DoPaint() 
{
	int x,y; 

	m_iCount=0;
	for(x=0;x<8;x++)
		for(y=0;y<10;y++)
		{
			m_pBlock[x][y]->SetBitmap(m_bmBlock[current[x][y]]);
			if(current[x][y] && current[x][y] < 9)
				m_iCount++;
		}
	
	m_strCount.Format(TEXT("%d"),m_iCount);
	m_strLevel.Format(TEXT("%d"),m_iLevel);
	UpdateData(FALSE);
}

void CPocketIrkedDlg::OnAbout() 
{
	CAbout dlgAbout;

	dlgAbout.DoModal();
	
}
