// LookupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "irked2.h"
#include "LookupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLookupDlg dialog


CLookupDlg::CLookupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLookupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLookupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CLookupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLookupDlg)
	DDX_Control(pDX, IDC_LEVELS, m_lbLevles);
	DDX_Control(pDX, IDC_URL, m_sURL);
	DDX_Control(pDX, IDC_DESCRIPTION, m_sDescription);
	DDX_Control(pDX, IDC_AUTHOR, m_sAuthor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLookupDlg, CDialog)
	//{{AFX_MSG_MAP(CLookupDlg)
	ON_LBN_SELCHANGE(IDC_LEVELS, OnSelchangeLevels)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLookupDlg message handlers

BOOL CLookupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	int i;
	
	m_sAuthor.SetWindowText(m_strAuthor);
	m_sURL.SetWindowText(m_strURL);
	m_sDescription.SetWindowText(m_strDescription);

	for(i=0;i<=m_iMaxLevel;i++)
	{
		CString str;
		CLevel *pLevel;
		
		m_pmwpLevels->Lookup(i,(void*&)pLevel);
		str.Format("%d: %s",i,pLevel->m_strTitle);
		m_lbLevles.AddString(str);
	}
	
	m_lbLevles.SetCurSel(m_iCurrentLevel);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLookupDlg::OnSelchangeLevels() 
{
	m_iSelected	= m_lbLevles.GetCurSel();
}
