// PreferencesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "irked2.h"
#include "PreferencesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPreferencesDlg dialog


CPreferencesDlg::CPreferencesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPreferencesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPreferencesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPreferencesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPreferencesDlg)
	DDX_Control(pDX, IDC_TILESET, m_cbTileSet);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPreferencesDlg, CDialog)
	//{{AFX_MSG_MAP(CPreferencesDlg)
	ON_CBN_SELCHANGE(IDC_TILESET, OnSelchangeTileset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPreferencesDlg message handlers

BOOL CPreferencesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	HDC hDC=::GetDC(NULL);
	m_bColor=::GetDeviceCaps(hDC,BITSPIXEL)<8?0:1;
	::ReleaseDC(NULL,hDC);

	m_iTileSet=1000+(m_bColor*100);

	if(m_bColor)
	{
		m_cbTileSet.AddString(_T("Standard"));
		m_cbTileSet.AddString(_T("Numbers"));
		m_cbTileSet.AddString(_T("Greek Letters"));
		m_cbTileSet.AddString(_T("Potpouri"));
		m_cbTileSet.AddString(_T("Pill Box"));
		m_cbTileSet.AddString(_T("Dingbats"));
		m_cbTileSet.AddString(_T("Bobles"));
		m_cbTileSet.AddString(_T("International"));
	}
	else
	{
		m_cbTileSet.AddString(_T("Standard"));
		m_cbTileSet.AddString(_T("Numbers"));
		m_cbTileSet.AddString(_T("Greek Letters"));
	}

	m_cbTileSet.SetCurSel(0);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPreferencesDlg::OnSelchangeTileset() 
{
	m_iTileSet=1000+(m_cbTileSet.GetCurSel()*10)+(m_bColor*100);
}
