// irked2Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "irked2.h"
#include "irked2Dlg.h"
#include "BasicLevels.h"
#include "LevelPacksDlg.h"
#include "PreferencesDlg.h"
#include "AreYouSureDlg.h"
#include "LookupDlg.h"
#include "BlocksRemainingDlg.h"
#include "HowToPlayDlg.h"

#define HINIBBLE(b)   ((BYTE) (((BYTE) (b) >> 4) & 0x0F)) 
#define LONIBBLE(b)   ((BYTE) (((BYTE) (b)) & 0x0F)) 
#define LINELEN (180)


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CLevel::CLevel()
{
	m_strTitle.Empty();
	m_btSolution[0]=NULL;
}

void CLevel::operator =(CLevel& that)
{
	int i,j;
	
	for(i=0;i<10;i++)
		for(j=0;j<8;j++)
			m_lBits[j][i]=that.m_lBits[j][i];
	m_strTitle = that.m_strTitle;;
	
	strcpy((char*)m_btSolution,(char*)(that.m_btSolution));
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIrked2Dlg dialog

CIrked2Dlg::CIrked2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CIrked2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIrked2Dlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CIrked2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIrked2Dlg)
	DDX_Control(pDX, IDC_TITLE, m_sTitle);
	DDX_Control(pDX, IDC_DESCRIPTION, m_sDescription);
	DDX_Control(pDX, IDC_URL, m_sURL);
	DDX_Control(pDX, IDC_AUTHOR, m_sAuthor);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIrked2Dlg, CDialog)
	//{{AFX_MSG_MAP(CIrked2Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_GAME_MEMORIZE, OnGameMemorize)
	ON_COMMAND(ID_GAME_PREFERENCES, OnGamePreferences)
	ON_COMMAND(ID_GAME_RECALL, OnGameRecall)
	ON_COMMAND(ID_GAME_RESETCURRENTLEVEL, OnGameResetcurrentlevel)
	ON_COMMAND(ID_GAME_UNDO, OnGameUndo)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_HELP_HOWTOPLAY, OnHelpHowtoplay)
	ON_COMMAND(ID_LEVELS_BLOCKSREMAINING, OnLevelsBlocksremaining)
	ON_COMMAND(ID_LEVELS_BYPASSLEVEL, OnLevelsBypasslevel)
	ON_COMMAND(ID_LEVELS_FIRST, OnLevelsFirst)
	ON_COMMAND(ID_LEVELS_LAST, OnLevelsLast)
	ON_COMMAND(ID_LEVELS_LEVELPACKS, OnLevelsLevelpacks)
	ON_COMMAND(ID_LEVELS_LOOKUP, OnLevelsLookup)
	ON_COMMAND(ID_LEVELS_NEXT, OnLevelsNext)
	ON_COMMAND(ID_LEVELS_PREVIOUS, OnLevelsPrevious)
	ON_COMMAND(ID_LEVELS_RESETPACK, OnLevelsResetpack)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIrked2Dlg message handlers

BOOL CIrked2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CMenu *pMenu=GetMenu();


	CIrked2App* pApp = (CIrked2App*)AfxGetApp();
	int i,j;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_tbSecondBar.Create(CCS_BOTTOM|WS_VISIBLE|WS_CHILD|WS_BORDER, CRect(0,250,240,274),this,4000);

	TBBUTTON tbb[]=
	{
					{4,ID_LEVELS_FIRST,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{5,ID_LEVELS_PREVIOUS,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{6,ID_LEVELS_LOOKUP,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{7,ID_LEVELS_NEXT,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{8,ID_LEVELS_LAST,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{-1,TBSTYLE_SEP,NULL,-1},
					{0,ID_GAME_RESETCURRENTLEVEL,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{-1,TBSTYLE_SEP,NULL,-1},
					{1,ID_GAME_UNDO,(BYTE)(TBSTATE_INDETERMINATE),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{2,ID_GAME_RECALL,(BYTE)(TBSTATE_INDETERMINATE),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
					{3,ID_GAME_MEMORIZE,(BYTE)(TBSTATE_ENABLED),(BYTE)(TBSTYLE_BUTTON|WS_BORDER),NULL,-1},
	};

	m_tbSecondBar.AddBitmap(1,IDB_RESET);
	m_tbSecondBar.AddBitmap(1,IDB_UNDO);
	m_tbSecondBar.AddBitmap(1,IDB_RECALL);
	m_tbSecondBar.AddBitmap(1,IDB_MEMORY);
	m_tbSecondBar.AddBitmap(1,IDB_FIRST);
	m_tbSecondBar.AddBitmap(1,IDB_BACK);
	m_tbSecondBar.AddBitmap(1,IDB_LOOKUP);
	m_tbSecondBar.AddBitmap(1,IDB_NEXT);
	m_tbSecondBar.AddBitmap(1,IDB_LAST);
	m_tbSecondBar.AddButtons(11,tbb);


	HDC hDC=::GetDC(NULL);
	BOOL bColor=::GetDeviceCaps(hDC,BITSPIXEL)<8?0:1;
	::ReleaseDC(NULL,hDC);

	m_iTileset=pApp->GetProfileInt("global", "tileset", 1000);
	if(1000 == m_iTileset)
	{	
		m_iTileset = 1000+(bColor*100);
	}

	m_bmpBricks[0].LoadBitmap(IDB_BLANK); // loads the initial set
	for(i=1;i<10;i++)
		m_bmpBricks[i].LoadBitmap(i+m_iTileset); // loads the initial set

	for(i=0;i<10;i++)
	{
		for(j=0;j<8;j++)
		{
			m_sBricks[i][j].Create(NULL, WS_VISIBLE|WS_CHILD|SS_BITMAP, CRect(0,0,16,16),this,1000+(10*i)+j); // create the blocks
			m_sBricks[i][j].MoveWindow(16+(i*16),16+(j*16),16,16);   // move them into place
			m_sBricks[i][j].SetBitmap(m_bmpBricks[9]);
		}
	}
	
	m_strPack=pApp->GetProfileString("global", "pack", "pocketirked2builtin");
	m_iMaxLevel=pApp->GetProfileInt(m_strPack, "level", 0);
	m_iLevelScore=pApp->GetProfileInt(m_strPack, "score", 0);
	LoadLevels(m_strPack);
	PlayLevel(m_iMaxLevel);


	m_iMoves=0;

	if(m_iCurrentLevel == m_iMaxLevel)
	{
		m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
		pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
		m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);
	}
	if(!m_iCurrentLevel)
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
	}

	OnUpdate();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIrked2Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CIrked2Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CIrked2Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CIrked2Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rcBase, rcBrick;
	int i,j;
	CMenu* pMenu=GetMenu();

	int iMenuHeight=GetSystemMetrics(SM_CYMENUSIZE);
	int iCaptionHeight=GetSystemMetrics(SM_CYCAPTION);
	GetWindowRect(rcBase);

	for(i=0;i<10;i++)
		for(j=0;j<8;j++)
		{
			m_sBricks[i][j].GetWindowRect(rcBrick);
			rcBrick.OffsetRect(-rcBase.left,-rcBase.top-iMenuHeight-iCaptionHeight);
			if(rcBrick.PtInRect(point))
			{
				if(m_lPlayGround.m_lBits[j][i] && m_lPlayGround.m_lBits[j][i] < 9)
				{
					m_iDnI=i;
					m_iDnJ=j;
				}
				else
				{
					m_iDnI=-1;
					m_iDnJ=-1;
				}
			}
		}

	CDialog::OnLButtonDown(nFlags, point);
}

void CIrked2Dlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CMenu *pMenu=GetMenu();
	CRect rcBase, rcBrick;
	BYTE mark[8][10];
	BOOL moved;
	CIrked2App* pApp=(CIrked2App*)AfxGetApp();
	int iMenuHeight=GetSystemMetrics(SM_CYMENUSIZE);
	int iCaptionHeight=GetSystemMetrics(SM_CYCAPTION);

	int i,j, iUpI, iUpJ;

	if(m_iDnJ == -1)
		return;

	GetWindowRect(rcBase);

	BOOL bPushed=FALSE;

	for(i=0;i<10;i++)
	{
		for(j=0;j<8;j++)
		{
			m_sBricks[i][j].GetWindowRect(rcBrick);
			rcBrick.OffsetRect(-rcBase.left,-rcBase.top-iMenuHeight-iCaptionHeight);
			if(rcBrick.PtInRect(point))
			{
				iUpI=i;
				iUpJ=j;

				if(iUpJ>9 || iUpI>8 || iUpJ<0 || iUpI<0)
					return;

				/***
				CString strMsg;
				strMsg.Format(TEXT("%d,%d->%d,%d"),m_iDnI,m_iDnJ,iUpI,iUpJ);
				MessageBox(strMsg);
				***/

			// if a block was moved to the left or right
			if((iUpJ == m_iDnJ) && ((iUpI == m_iDnI+1) || (iUpI == m_iDnI-1)))
			{
				if(m_lPlayGround.m_lBits[iUpJ][iUpI] == 0)
				{
					if(!bPushed)
					{
						bPushed=TRUE;
						Push();
						m_iMoves++;
						m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
						pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);


					}
					// move block
					m_lPlayGround.m_lBits[iUpJ][iUpI] = m_lPlayGround.m_lBits[m_iDnJ][m_iDnI];
					m_lPlayGround.m_lBits[m_iDnJ][m_iDnI]=0;
					OnUpdate();
				}
			
			// fall blocks
				
				do
				{
					do
					{
						moved=FALSE;
						for(i=0;i<10;i++)
						{
							for(j=6;j>=0;j--)
							{
								if((m_lPlayGround.m_lBits[j][i] != 9) && (m_lPlayGround.m_lBits[j][i] != 0) && m_lPlayGround.m_lBits[j+1][i] == 0)
								{
									m_lPlayGround.m_lBits[j+1][i]=m_lPlayGround.m_lBits[j][i];
									m_lPlayGround.m_lBits[j][i]=0;
									moved=TRUE;
									OnUpdate();
								}
							}
						}
					}while(moved);

					// knock out blocks

					// This SEGMENT taken directly from VEXED 
					// James McCombe
					// cybertube@earthling.net
					// http://spacetube.tsx.org

					// just go through from top to bottom marking pieces which have matches above, below, left and to the right of them
					for (j = 0; j<8; j++)
					{
						for (i = 0; i<10; i++)
						{
							mark[j][i] = 0; // ALWAYS initialise each element in the 'mark' array
							if (!((m_lPlayGround.m_lBits[j][i] == 0) || (m_lPlayGround.m_lBits[j][i] == 9))) // only check if its not air or a wall block
							{
								mark[j][i] |= (m_lPlayGround.m_lBits[j - 1][i] == m_lPlayGround.m_lBits[j][i]); // if there is an identical piece above then mark this piece
								mark[j][i] |= (m_lPlayGround.m_lBits[j + 1][i] == m_lPlayGround.m_lBits[j][i]); // if there is an identical piece below then mark this piece
								mark[j][i] |= (m_lPlayGround.m_lBits[j][i + 1] == m_lPlayGround.m_lBits[j][i]); // if there is an identical piece to the right then mark this piece
								mark[j][i] |= (m_lPlayGround.m_lBits[j][i - 1] == m_lPlayGround.m_lBits[j][i]); // if there is an identical piece to the left then mark this piece
							}
						}
					}
					// END SEGMENT
			

					// go through the current level array checking if a piece is marked and if so, remove it
					for (j = 0; j <= 7; j ++)
						for (i = 0; i <= 9; i ++)
							if (mark[j][i])
							{
								m_lPlayGround.m_lBits[j][i]=0;
								OnUpdate();
								moved=TRUE;
							}
					}while(moved);
				}
			}
		}
	}

	if(!m_iCount)
	{
		// do scoring;
		/***
		I'm not sure how scoring should persist, Is the score global?
		per pack?  Are there players?
		
		scoring will persist for each pack, until it is cleared
		
		
		  score += moves - par
		***/

		// only score if this is for advancement
		if(m_iCurrentLevel == m_iMaxLevel)
		{
			m_iLevelScore+=(m_iMoves-(strlen((char*)(m_lPlayGround.m_btSolution))/2));
			CString str;
			str.Format("Par: %d   Score: %d",strlen((char*)(m_lPlayGround.m_btSolution))/2, m_iLevelScore);
			//m_sAuthor.SetWindowText(str);

			pApp->WriteProfileInt(m_strPack,CString("score"),m_iLevelScore);
		}

		if(m_iCurrentLevel == m_iMaxLevel)
		{
			if(m_iMaxLevel < m_iMaxPackLevel)
			{
				m_iMaxLevel++;
				pApp->WriteProfileInt(m_strPack,_T("level"),m_iMaxLevel);
			}
		}

		m_iMoves=0;
		OnLevelsNext();
	}
	CDialog::OnLButtonUp(nFlags, point);
}

void CIrked2Dlg::OnGameMemorize() 
{
	CMenu *pMenu=GetMenu();

	m_bMemory=TRUE;
	m_lMemory=m_lPlayGround;
	
	m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_ENABLED);
	pMenu->EnableMenuItem(ID_GAME_RECALL,MF_ENABLED);
}

void CIrked2Dlg::OnGamePreferences() 
{
	CPreferencesDlg PreferecesDlg;
	CIrked2App *pApp =(CIrked2App *)AfxGetApp();
	int i;
	
	PreferecesDlg.DoModal();

	for(i=1;i<10;i++)
	{
		m_bmpBricks[i].DeleteObject();
		m_bmpBricks[i].LoadBitmap(PreferecesDlg.m_iTileSet+i); // loads the newl set
	}
	pApp->WriteProfileInt("global","tileset",PreferecesDlg.m_iTileSet);
	OnUpdate();
}

void CIrked2Dlg::OnGameRecall() 
{
	CMenu *pMenu=GetMenu();

	Push();
	m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
	pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);
	if(m_bMemory)
	{
		m_lPlayGround=m_lMemory;
		OnUpdate();
	}
	else
	{
		Pop();
		if(!m_llUndoStack.GetCount())
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
		}
	}
}

void CIrked2Dlg::OnGameResetcurrentlevel() 
{
	PlayLevel(m_iCurrentLevel);
	OnUpdate();
}

void CIrked2Dlg::OnGameUndo() 
{
	CMenu *pMenu=GetMenu();

	Pop();
	if(!m_llUndoStack.GetCount())
	{
		m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
	}

	OnUpdate();
}

void CIrked2Dlg::OnHelpAbout() 
{
	CAboutDlg dlg;
	dlg.DoModal();
}

void CIrked2Dlg::OnHelpHowtoplay() 
{
	CHowToPlayDlg HowToPlayDlg;
	
	HowToPlayDlg.DoModal();
}

void CIrked2Dlg::OnLevelsBlocksremaining() 
{
	CBlocksRemainingDlg	BlockRemainingDlg;

	BlockRemainingDlg.m_pBitmaps = m_bmpBricks;
	BlockRemainingDlg.m_pLevel = &m_lPlayGround;
	BlockRemainingDlg.DoModal();
}

void CIrked2Dlg::OnLevelsBypasslevel() 
{
	CAreYouSureDlg dlg;
	int TotalMoves, MoveNum;
	char chI, chJ; 
	int i, j, i2;//, j2;
	BOOL direction;
#define Left (TRUE)
#define Right (FALSE)

	if(IDOK == dlg.DoModal())
	{
		OnGameResetcurrentlevel();
		m_iLevelScore+=strlen((char*)m_lPlayGround.m_btSolution);
		if(m_lPlayGround.m_btSolution[0])
		{
			TotalMoves=strlen((char*)m_lPlayGround.m_btSolution)/2;

			for(MoveNum=0;MoveNum < TotalMoves;MoveNum++)
			{
	/***/

		// the question is should this play in the normal window or pop up a solutions
		// window. I'm thinking that 5pts should be added for each hint
		// must start with a fresh board.

				chI = m_lPlayGround.m_btSolution[MoveNum * 2];
				chJ = m_lPlayGround.m_btSolution[MoveNum * 2 + 1];
   
				i = chI - 'a';
				if (chI <= 'Z') 
				{
					direction = Left;
					i = chI - 'A';
				}
				j = chJ - 'a';
				if (chJ <= 'Z') 
				{
					direction = Right;
					j = chJ - 'A';
				}

				if(direction == Right)
				{
					i2=i+1;
				}
				else
				{
					i2=i-1;
				}

				// Check for validity

				if (j < 0 || j >= 8 || i < 0 || i >= 10) 
				{
					return;
				}

		//These should be translated to MouseDown and MouseUp calls

				OnLButtonDown(0,CPoint(16+(i*16)+8,16+(j*16)+8));
				OnLButtonUp(0,CPoint(16+(i2*16)+8,16+(j*16)+8)); // there is no j2 because you can't move down
  
	/***/
			}
		}
	}
}

void CIrked2Dlg::OnLevelsFirst() 
{
	CMenu *pMenu=GetMenu();
	// if already at the first level, do nothing
	if(m_iCurrentLevel)
	{
		PlayLevel(0);

		if(m_iCurrentLevel == m_iMaxLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);
		}
		if(!m_iCurrentLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
		}

		if(!m_llUndoStack.GetCount())
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);
		}
		
		m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
		OnUpdate();
	}
}

void CIrked2Dlg::OnLevelsLast() 
{
	CMenu *pMenu=GetMenu();

	PlayLevel(m_iMaxLevel);

	if(m_iCurrentLevel == m_iMaxLevel)
	{
		m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
		pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
		m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);

	}

	if(!m_iCurrentLevel)
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
	}

	if(!m_iMaxLevel)
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
		m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
		pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
	}

	if(!m_llUndoStack.GetCount())
	{
		m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
	}
	else
	{
		m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
		pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);
	}

	m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
	pMenu->EnableMenuItem(ID_GAME_RECALL,MF_GRAYED);

	OnUpdate();
}

void CIrked2Dlg::OnLevelsLevelpacks() 
{
	CIrked2App* pApp = (CIrked2App*)AfxGetApp();
	CMenu *pMenu=GetMenu();

	CLevelPacksDlg LevelPacksDlg;
	int iRet;

	iRet=LevelPacksDlg.DoModal();
	if(iRet == IDOK) 
	{					 
		if(LevelPacksDlg.m_strLevelSelected.GetLength())
		{
			int iLevel;	    

			m_strPack=LevelPacksDlg.m_strLevelSelected+TEXT(".lvl");
			pApp->WriteProfileString("global","pack",m_strPack);
			iLevel=pApp->GetProfileInt(m_strPack,"level",0);

			LoadLevels(m_strPack);
			PlayLevel(iLevel);
			m_iMaxLevel=iLevel;

			if(m_iCurrentLevel == m_iMaxLevel)
			{
				m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
				m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
				pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
				pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
			}
			else
			{
				m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
				m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
				pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
				pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);
			}
			if(!m_iCurrentLevel)
			{
				m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
				m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
				pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
				pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
			}
			else
			{
				m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
				m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
				pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
				pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
			}

			m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_GAME_RECALL,MF_GRAYED);
			OnUpdate();
		}
	}
}

void CIrked2Dlg::OnLevelsLookup() 
{
	CLookupDlg dlg;
	/***
	pop up a dialog with the levels listed in numeric order
	along with their names, only completed levels should be listed. ???

  Also display the pack data, author, url, description

  Not so sure I want to display that info on the play screen, except maybe the pack name
	***/
	dlg.m_strAuthor = m_strAuthor;
	dlg.m_strURL = m_strURL;
	dlg.m_strDescription = m_strDescription;

	dlg.m_iMaxLevel = m_iMaxLevel;
	dlg.m_iCurrentLevel = m_iCurrentLevel;
	dlg.m_pmwpLevels = &m_mwpLevels;

	if(IDOK == dlg.DoModal())
	{
		PlayLevel(dlg.m_iSelected);

		if(m_iCurrentLevel == m_iMaxLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
		}
		if(!m_iCurrentLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
		}

		m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
		m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
		OnUpdate();
	}
}

void CIrked2Dlg::OnLevelsNext() 
{
	CMenu *pMenu=GetMenu();

	if(m_iCurrentLevel < m_iMaxLevel)
	{
		PlayLevel(m_iCurrentLevel+1);

		if(m_iCurrentLevel == m_iMaxLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);
		}
		if(!m_iCurrentLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
		}
		
		m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_GAME_RECALL,MF_GRAYED);

		if(!m_llUndoStack.GetCount())
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);
		}

	}
	OnUpdate();
}

void CIrked2Dlg::OnLevelsPrevious() 
{
	CMenu *pMenu=GetMenu();

	// if there is no previous level, do nothing
	if(m_iCurrentLevel)
	{
		PlayLevel(m_iCurrentLevel-1);

		if(m_iCurrentLevel == m_iMaxLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_LAST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_NEXT,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_LAST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_NEXT,MF_ENABLED);
		}
		if(!m_iCurrentLevel)
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_INDETERMINATE);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_GRAYED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_LEVELS_FIRST,TBSTATE_ENABLED);
			m_tbSecondBar.SetState(ID_LEVELS_PREVIOUS,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_FIRST,MF_ENABLED);
			pMenu->EnableMenuItem(ID_LEVELS_PREVIOUS,MF_ENABLED);
		}
		
		if(!m_llUndoStack.GetCount())
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);
		}
		else
		{
			m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_ENABLED);
			pMenu->EnableMenuItem(ID_GAME_UNDO,MF_ENABLED);
		}

		m_tbSecondBar.SetState(ID_GAME_RECALL,TBSTATE_INDETERMINATE);
		pMenu->EnableMenuItem(ID_GAME_RECALL,MF_GRAYED);

		OnUpdate();
	}
}

void CIrked2Dlg::OnLevelsResetpack() 
{
	CIrked2App *pApp=(CIrked2App*)AfxGetApp();

	m_iMaxLevel=0;
	m_iLevelScore=0;
	pApp->WriteProfileInt(m_strPack,"level",0);
	pApp->WriteProfileInt(m_strPack,"score",0);

	OnLevelsFirst();
}

BOOL CIrked2Dlg::Push()
{
	CLevel *pLevel = new CLevel();

	(*pLevel)=m_lPlayGround;

	m_llUndoStack.AddHead(pLevel);
	if(m_llUndoStack.GetCount() > 15)
		m_llUndoStack.RemoveTail();

	return FALSE;
}

BOOL CIrked2Dlg::Pop()
{
	CLevel *pLevel;
	if(m_llUndoStack.GetCount())
	{
		pLevel = m_llUndoStack.RemoveHead();
		m_lPlayGround = (*pLevel);
		delete pLevel;
	}

	return FALSE;
}

void CIrked2Dlg::OnUpdate() 
{
	int i,j;
	m_iCount=0;
	for(i=0;i<10;i++)
		for(j=0;j<8;j++)
		{	
			m_sBricks[i][j].SetBitmap(m_bmpBricks[m_lPlayGround.m_lBits[j][i]]);
			if(m_lPlayGround.m_lBits[j][i] && m_lPlayGround.m_lBits[j][i] < 9 )
				m_iCount++;
		}

	SleepEx(275,TRUE);
	CString str;


	str.Format("Par: %d   Score: %d",strlen((char*)(m_lPlayGround.m_btSolution))/2, m_iLevelScore);
	m_sAuthor.SetWindowText(str);

	str.Format("Moves: %d",m_iMoves);
	m_sURL.SetWindowText(str);
	m_sDescription.SetWindowText(m_strDescription);

	CString strTitle;
	strTitle.Format("%d: %s",m_iCurrentLevel,m_lPlayGround.m_strTitle);
	m_sTitle.SetWindowText(strTitle);

	UpdateData(FALSE);
}

int CIrked2Dlg::LoadLevels(LPCTSTR strFilename) // if the fname is empty then you should load the basic levels from memeory
{
	int i,j,k;
	CHAR *noteof;

	// clean them out
	i= m_mwpLevels.GetCount();
	for(j=0;j<i;j++)
	{
		CLevel *pLevel;
		m_mwpLevels.Lookup(j,(void*&)pLevel);
		delete pLevel;
	}
	m_mwpLevels.RemoveAll();

	// load from file
	if(strcmp(strFilename,"pocketirked2builtin"))
	{
		FILE *f;
		char line[LINELEN];

		if(f=fopen(CString("c:\\Program Files\\ipidooma.net\\irked2\\levels\\")+strFilename,"r"))
		{
			k=0;
			noteof=fgets(line,LINELEN,f);
			while(noteof)
			{		
				if(line[0] == '[') 
				{ // found the beginning of a section
					//is it a general or a level?

					if(!_strnicmp(line,"[general]",9))
					{
						do
						{
							if(!fgets(line,LINELEN,f))
								break;
							if(line[0] != '[')
							{
								char *tok;

								// in here we look for
								// Author=
								// URL=
								// Description=
								
								tok=strtok(line,"=\r\n");
								if(tok && !_stricmp(tok,"author"))
								{
									//char *author;
									m_strAuthor=strtok(NULL,"\r\n");
									//printf("author: %s\n",author);
								}
								else if(tok && !_stricmp(tok,"url"))
								{
									//char *url;
									m_strURL=strtok(NULL,"\r\n");
									//printf("url: %s\n",url);
								}
								else if(tok && !_stricmp(tok,"description"))
								{
									char *description;
									description=strtok(NULL,"\r\n");
									m_strDescription=description;
									//printf("description: %s\n",description);
								}
							}
						}while(line[0] != '[');
					}
					
					if(!_strnicmp(line,"[level]",7))
					{
						CLevel *pLevel = new CLevel();
						m_mwpLevels.SetAt(k,pLevel);

						do
						{
							if(!fgets(line,LINELEN,f))
								break;
							if(line[0] != '[')
							{
								char *tok;

								// board
								// solution
								// title

								tok=strtok(line,"=\r\n");
								if(tok && !_stricmp(tok,"board"))
								{
									char *board;
									board=strtok(NULL,"\r\n");
									ParseLevelNotation(board, pLevel);
									//printf("board: %s\n",board);
								}
								else if(tok && !_stricmp(tok,"solution"))
								{
									char *solution;
									solution=strtok(NULL,"\r\n");
									strcpy((char*)pLevel->m_btSolution,solution);
									//printf("solution: %s\n",solution);
								}
								else if(tok && !_stricmp(tok,"title"))
								{
									char *title;
									title=strtok(NULL,"\r\n");
 									pLevel->m_strTitle=CString(title);
									//printf("title: %s\n",title);
								}
							}
						}while(line[0] != '[');
						
						k++;
					}
				}
				else
				{
					noteof=fgets(line,LINELEN,f);
				}
			}
			fclose(f);
			m_iMaxPackLevel=m_mwpLevels.GetCount()-1;
			return 0;

		}
		else
		{  // pack was not found, load the builtins
			m_strPack="pocketirked2builtin";
		}

	}
/**/
	for(k=0;k<118;k++)
	{
		CLevel *pLevel = new CLevel();
		m_mwpLevels.SetAt(k,pLevel);
		
		if(k < 59)
			pLevel->m_strTitle.Format(TEXT("Classic: Level %d"),k);
		else
			pLevel->m_strTitle.Format(TEXT("Classic II: Level %d"),k-59);
		pLevel->m_btSolution[0]=0;

		m_strAuthor=TEXT("James McCombe && Steve Haynal");
		m_strURL.Empty();
		m_strDescription=TEXT("Built in Levels");


		for(j=0;j<8;j++)
			for(i=0;i<10;i+=2)
			{
				pLevel->m_lBits[j][i]=HINIBBLE(lBasicLevels[k][j][i/2]);
				pLevel->m_lBits[j][i+1]=LONIBBLE(lBasicLevels[k][j][i/2]);
			}
	}
/**/
	m_iMaxPackLevel=m_mwpLevels.GetCount()-1;
	
	return 0;
}

BOOL CIrked2Dlg::ParseLevelNotation(char *pszLevel, CLevel *pLevel)
{
   BYTE level[8][10];
   BYTE *pbLoad;
   int i,j;
   
   // Validate the board and get the dimensions

	char *pszLast = pszLevel;
	BOOL fLoop = TRUE;
	int cRows = 0;
	int cCols = -1;
	while (fLoop) 
	{
      int cColsT;
		char *pszNext = strchr(pszLast, '/');
		if (pszNext == NULL) 
		{
			pszNext = pszLast + strlen(pszLast);
			fLoop = FALSE;
		}
		cColsT = LoadLevelRow(NULL, pszLast, pszNext);
		if (cCols == -1) 
		{
			cCols = cColsT;
		} 
		else if (cCols != cColsT) 
		{
			return FALSE;
		}
		cRows++;
		pszLast = pszNext + 1;
	}

	// Vexed wants these sizes

	if (cCols != 10 || cRows != 8)
		return FALSE;

	// Load it this time

	pbLoad = &level[0][0];
	pszLast = pszLevel;
	fLoop = TRUE;
	while (fLoop) 
	{
		// Find the end of this row

		char *pszNext = strchr(pszLast, '/');
		if (pszNext == NULL) 
		{
			pszNext = pszLast + strlen(pszLast);
			fLoop = FALSE;
		}

		// Load the row

		LoadLevelRow(pbLoad, pszLast, pszNext);

		// Next row...

		pbLoad += 10;
		pszLast = pszNext + 1;
	}

   // Convert into *pLevel format

	for(i=0;i<10;i++)
	{
		for(j=0;j<8;j++)
		{
			pLevel->m_lBits[j][i]=level[j][i];
		}
	}

   return TRUE;
}

int CIrked2Dlg::LoadLevelRow(byte *pb, char *psz, char *pszMax)
{
	int cBlocks = 0;
	for (; psz < pszMax; psz++) 
	{
		char ch = *psz;

		// Is this a number (non-moveable blocks?)
		
		int c = 0;
		while (ch >= '0' && ch <= '9') 
		{
			c = c * 10 + ch - '0';
			psz++;
			if (psz >= pszMax)
				break;
			ch = *psz;
		}
		if (c != 0) 
		{
			cBlocks += c;
			if (pb != NULL) 
			{
				while (c != 0) 
				{
					*pb++ = 9;
					c--;
				}
			}
			psz--;
			continue;
		}

		// Is this empty space?

		if (ch == '~') 
		{
			cBlocks++;
			if (pb != NULL)
				*pb++ = 0;
			continue;
		}

		// This is a block type. Remember it verbatim

      if (ch < 'a' || ch > 'h')
         return -1;

		cBlocks++;
		if (pb != NULL)
			*pb++ = ch - 'a' + 1;
	}

	return cBlocks;
}

int CIrked2Dlg::PlayLevel(int iLevel)
{
	int i,j;
	CLevel *pLevel=NULL;
	CMenu *pMenu=GetMenu();

	m_bMemory=FALSE; // gets reset when we reload or advance
	while(m_llUndoStack.GetCount())
	{
		delete m_llUndoStack.RemoveHead();
	}
	m_tbSecondBar.SetState(ID_GAME_UNDO,TBSTATE_INDETERMINATE);
	pMenu->EnableMenuItem(ID_GAME_UNDO,MF_GRAYED);

	if(iLevel >=0 && iLevel <= m_mwpLevels.GetCount())
	{
		m_mwpLevels.Lookup(iLevel,(void *&)pLevel);

		if(pLevel)
		{
			m_iCurrentLevel=iLevel;
			m_lPlayGround.m_strTitle=pLevel->m_strTitle;
			strcpy((char*)m_lPlayGround.m_btSolution,(char*)pLevel->m_btSolution);
			for(i=0;i<10;i++)
				for(j=0;j<8;j++)
					m_lPlayGround.m_lBits[j][i]=pLevel->m_lBits[j][i];
			
			CString strTitle;
			strTitle.Format(_T("%d: %s"),m_iCurrentLevel,pLevel->m_strTitle);
			m_sTitle.SetWindowText(strTitle);
		}
	}
	return 0;
}


int CIrked2Dlg::DoModal() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	int iRet=CDialog::DoModal();
	int i;

	for(i=0;i<=m_iMaxPackLevel;i++)
	{
		CLevel *pLevel;

		m_mwpLevels.Lookup(i,(void*&)pLevel);
		delete pLevel;
	}
	m_mwpLevels.RemoveAll();

	while(m_llUndoStack.GetCount())
	{
		CLevel *pLevel;

		pLevel=m_llUndoStack.RemoveHead();
		delete pLevel;
	}

	return iRet;
}

