// irked2Dlg.h : header file
//

#if !defined(AFX_IRKED2DLG_H__77087A38_E752_4BEC_8A3D_57128360BCDA__INCLUDED_)
#define AFX_IRKED2DLG_H__77087A38_E752_4BEC_8A3D_57128360BCDA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CIrked2Dlg dialog

class CLevel : public CObject
{
public:
	CLevel();
	void operator =(CLevel& that);

	BYTE m_lBits[8][10];
	CString m_strTitle;
	BYTE m_btSolution[180];
};

class CIrked2Dlg : public CDialog
{
// Construction
public:
	CIrked2Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CIrked2Dlg)
	enum { IDD = IDD_IRKED2_DIALOG };
	CStatic	m_sTitle;
	CStatic	m_sDescription;
	CStatic	m_sURL;
	CStatic	m_sAuthor;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIrked2Dlg)
	public:
	virtual int DoModal();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;
	CToolBarCtrl m_tbSecondBar;
	CBitmap m_bmpBricks[10];
	CStatic m_sBricks[10][8];

	int m_iTileset;

	int m_iMaxLevel;
	int m_iMaxPackLevel;
	int m_iLevelScore;
	int m_iMoves;
	int m_iCount;
	int m_iCurrentLevel;
	void OnUpdate();

	CString m_strPack;
	CString m_strAuthor;
	CString m_strURL;
	CString m_strDescription;
	BOOL m_bMemory;
	CLevel m_lMemory;
	CMapWordToPtr m_mwpLevels;
	int LoadLevels(LPCTSTR strFilename="pocketirked2builtin");
	BOOL ParseLevelNotation(char *pszLevel, CLevel *pLevel);
	int LoadLevelRow(byte *pb, char *psz, char *pszMax);
	int PlayLevel(int iLevel=0);

	CLevel m_lPlayGround;
	int m_iDnI;
	int m_iDnJ;

	CList<CLevel*, CLevel*> m_llUndoStack;
	BOOL Push();
	BOOL Pop();
	// Generated message map functions
	//{{AFX_MSG(CIrked2Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnGameMemorize();
	afx_msg void OnGamePreferences();
	afx_msg void OnGameRecall();
	afx_msg void OnGameResetcurrentlevel();
	afx_msg void OnGameUndo();
	afx_msg void OnHelpAbout();
	afx_msg void OnHelpHowtoplay();
	afx_msg void OnLevelsBlocksremaining();
	afx_msg void OnLevelsBypasslevel();
	afx_msg void OnLevelsFirst();
	afx_msg void OnLevelsLast();
	afx_msg void OnLevelsLevelpacks();
	afx_msg void OnLevelsLookup();
	afx_msg void OnLevelsNext();
	afx_msg void OnLevelsPrevious();
	afx_msg void OnLevelsResetpack();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IRKED2DLG_H__77087A38_E752_4BEC_8A3D_57128360BCDA__INCLUDED_)
