#include "stdafx.h"
#include "card.h"

/***
To use these classes:

  create a bunch of cards, add them to a deck
  deal them to a hand
  pass the hand to a game
  render the hand as needed
***/
IMPLEMENT_DYNAMIC(CCard, CObject) 
IMPLEMENT_DYNAMIC(CDeck, CObject) 
IMPLEMENT_DYNAMIC(CHand, CObject) 
IMPLEMENT_DYNAMIC(CGame, CObject) 
IMPLEMENT_DYNAMIC(CGameDucesWild, CGame) 
IMPLEMENT_DYNAMIC(CGameJackOrBetter, CGame) 
IMPLEMENT_DYNAMIC(CGameBonus, CGame) 
IMPLEMENT_DYNAMIC(CGameDoubleBonus, CGame) 


CCard::CCard(UINT uiSuit/*=NULL*/, UINT uiValue/*=NULL*/, UINT uiLargeFace/*=NULL*/, UINT uiSmallFace/*=NULL*/)
:CObject()
{
	m_uiSuit=uiSuit;
	m_uiValue=uiValue;
	m_bLargeFaceLoaded=0;
	m_bSmallFaceLoaded=0;

	if(uiLargeFace)
	{
		m_bLargeFaceLoaded=m_bmpLargeFace.LoadBitmap(uiLargeFace);
	}

	if(uiSmallFace)
	{
		m_bSmallFaceLoaded=m_bmpSmallFace.LoadBitmap(uiSmallFace);
	}
}

CCard::~CCard()
{
	if(m_bLargeFaceLoaded)
	{
		m_bmpLargeFace.DeleteObject();
	}

	if(m_bSmallFaceLoaded)
	{
		m_bmpSmallFace.DeleteObject();
	}
}

void CCard::Render(CDC* pDC, POINT* ppt, BOOL bLarge/*=FALSE*/)
{
	CDC dcMemDC;
	CBitmap *pbmpOldBmp;
	
	dcMemDC.CreateCompatibleDC(pDC);

	pbmpOldBmp=dcMemDC.SelectObject(bLarge?&m_bmpLargeFace:&m_bmpSmallFace);

	pDC->BitBlt(ppt->x,ppt->y,bLarge?GetLargeWidth():GetSmallWidth(),bLarge?GetLargeHeight():GetSmallHeight(),&dcMemDC,0,0, SRCCOPY);

	dcMemDC.SelectObject(pbmpOldBmp);

	dcMemDC.DeleteDC();
}

UINT CCard::GetValue()
{
	return m_uiValue;
}

UINT CCard::GetSuit()
{
	return m_uiSuit;
}

void CCard::SetValue(UINT uiValue)
{
	m_uiValue=uiValue;
}

void CCard::SetSuit(UINT uiSuit)
{
	m_uiSuit=uiSuit;
}

UINT CCard::GetSmallHeight()
{
	return 34;
}

UINT CCard::GetSmallWidth()
{
	return 25;
}

UINT CCard::GetLargeHeight()
{
	return 96;
}

UINT CCard::GetLargeWidth()
{
	return 71;
}


CDeck::CDeck(CArray<CCard*,CCard*>* ppcaCards/*=NULL*/)
:CObject()
{
	srand((unsigned)time(NULL));

	m_pcaCards.RemoveAll();

	if(ppcaCards)
	{
		m_pcaCards.Append(*ppcaCards);
	}
}

CDeck::~CDeck()
{
	m_pcaCards.RemoveAll();
	m_pcaBacks.RemoveAll();
	m_pcaSubDeck.RemoveAll();
	m_pcaDelt.RemoveAll();
}


void CDeck::Shuffle()
{
	CArray<CCard*,CCard*>pcaTmp;
	int offset;

	pcaTmp.Append(m_pcaCards);
	m_pcaCards.RemoveAll();

	while(pcaTmp.GetSize())
	{
		double d=(double)rand()/(double)RAND_MAX;
		if(d>0)
		{
			offset = (int)((double)(pcaTmp.GetSize()-1)*d);
			m_pcaCards.Add(pcaTmp.GetAt(offset));	
			pcaTmp.RemoveAt((int)((pcaTmp.GetSize()-1)*d));	
		}
	}
	//srand((unsigned)time(NULL)+offset);
}

void CDeck::CreateSubDeck()
{
	CArray<CCard*,CCard*>pcaTmp;

	pcaTmp.Append(m_pcaCards);
	m_pcaSubDeck.RemoveAll();

	while(pcaTmp.GetSize())
	{
		double d=(double)rand()/(double)RAND_MAX;
		if(d>0)
		{
			m_pcaSubDeck.Add(pcaTmp.GetAt((int)((double)(pcaTmp.GetSize()-1)*d)));	
			pcaTmp.RemoveAt((int)((pcaTmp.GetSize()-1)*d));	
		}
	}
}

CCard* CDeck::DealSubDeck()
{
	CCard* pCard;

	pCard=m_pcaSubDeck.GetAt(0);
	m_pcaSubDeck.RemoveAt(0);
	return pCard;
}

void CDeck::Add(CCard *pCard)
{
	m_pcaCards.Add(pCard);
}

void CDeck::SetBacks(CCard *pCard)
{
	m_pcaBacks.RemoveAll();
	m_pcaBacks.Add(pCard);
	m_pcaBacks.Add(pCard);
	m_pcaBacks.Add(pCard);
	m_pcaBacks.Add(pCard);
	m_pcaBacks.Add(pCard);
}

CArray<CCard*,CCard*>* CDeck::GetBacks()
{
	return &m_pcaBacks;
}

void CDeck::Add(CArray<CCard*,CCard*> *ppcaCards)
{
	m_pcaCards.Append(*ppcaCards);
}

void CDeck::Reset()
{
	m_pcaDelt.Append(m_pcaCards);
	m_pcaCards.RemoveAll();
	m_pcaCards.Append(m_pcaDelt);
	m_pcaDelt.RemoveAll();	
}

CCard* CDeck::Deal()
{
	CCard* pCard;

	pCard=m_pcaCards.GetAt(0);
	m_pcaCards.RemoveAt(0);
	m_pcaDelt.Add(pCard);
	return pCard;
}

void CDeck::DestroyCards()
{
	Reset();
	while(m_pcaCards.GetSize())
	{
		delete m_pcaCards.GetAt(0);
		m_pcaCards.RemoveAt(0);
	}

	delete m_pcaBacks.GetAt(0);
}

UINT CDeck::GetCount()
{
	return m_pcaCards.GetSize()+m_pcaDelt.GetSize();
}

UINT CDeck::GetRemainingCount()
{
	return m_pcaCards.GetSize();
}


CHand::CHand(CArray<CCard*,CCard*>* ppcaCards/*=NULL*/)
:CObject()
{
	m_pcaCards.RemoveAll();

	if(ppcaCards)
	{
		m_pcaCards.Append(*ppcaCards);
	}
}

CHand::~CHand()
{
	m_pcaCards.RemoveAll();
}


CCard* CHand::GetAt(int iIndex)
{
	return (*this)[iIndex];
}

void CHand::SetAt(int iIndex, CCard* pcCard)
{
	m_pcaCards.SetAt(iIndex,pcCard);
}

int CHand::Add(CCard* pcCard)
{
	return m_pcaCards.Add(pcCard);
}

void CHand::SetCards(CArray<CCard*,CCard*>* ppcaCards)
{
	int i;

	m_pcaCards.RemoveAll();
	for(i=0;i<ppcaCards->GetSize();i++)
	{
		m_pcaCards.Add((*ppcaCards)[i]);
	}
}

void CHand::Render(CDC* pDC, POINT* ppt, BOOL bLarge/*=FALSE*/)
{
	for(int i=0;i<m_pcaCards.GetSize();i++)
	{
		// assumes all cards are the same size
		CPoint pt(ppt->x+(bLarge?((m_pcaCards[i]->GetLargeWidth()+4)*i):((m_pcaCards[i]->GetSmallWidth()+1)*i)),ppt->y);
		m_pcaCards[i]->Render(pDC,&pt,bLarge);
	}
}

UINT CHand::GetSmallHeight()
{
	UINT uiSize=0;
	
	uiSize+=m_pcaCards[0]->GetSmallHeight();

	return uiSize;
}

UINT CHand::GetSmallWidth()
{
	UINT uiSize=0;
	for(int i=0;i<m_pcaCards.GetSize();i++)
	{
		uiSize+=m_pcaCards[i]->GetSmallWidth();
		uiSize++;
	}
	uiSize--;
	return uiSize;
}

UINT CHand::GetLargeHeight()
{
	UINT uiSize=0;

	uiSize+=m_pcaCards[0]->GetLargeHeight();

	return uiSize;
}

UINT CHand::GetLargeWidth()
{
	UINT uiSize=0;
	for(int i=0;i<m_pcaCards.GetSize();i++)
	{
		uiSize+=m_pcaCards[i]->GetLargeWidth();
		uiSize+=4;
	}
	uiSize-=4;
	return uiSize;
}

CCard* CHand::operator [](int iIndex)
{
	return m_pcaCards[iIndex];
}


CGame::CGame(CHand* phHand/*=NULL*/)
:CObject()
{
	m_phHand=phHand;
	if(m_phHand)
		m_uiValue=Eval(m_strName);
}

CGame::~CGame()
{
	m_strName.Empty();
}


void CGame::SetHand(CHand* phHand)
{
	m_phHand=phHand;
	m_uiValue=Eval(m_strName);
}

CHand* CGame::GetHand()
{
	return m_phHand;
}


UINT CGame::GetValue()
{
	return m_uiValue;
}

LPCTSTR CGame::GetName()
{
	return (LPCTSTR)m_strName;
}

UINT CGame::Eval(CString& strName)
{
	strName.Empty();
	return 0;
}

// I think I need a render function here as well
// the hand will render itself but it is the game that does
// the scoring, so it will be the game that renders any points
// flash.

void CGame::Render(CDC* pDC, POINT* ppt, BOOL bLarge/*=FALSE*/)
{

	// renders a caption rectangle, the color should be different for 
	// each class of win
	CPen pn(PS_SOLID,1,RGB(255,0,0));
	CPen *ppnOld;
	CPoint pt(3,3);
	// assumes all cards are the same size
	CRect rc(ppt->x,
			 ppt->y+1+(bLarge?(m_phHand->m_pcaCards[0]->GetLargeHeight()):(m_phHand->m_pcaCards[0]->GetSmallHeight())),
			 ppt->x+(bLarge?(m_phHand->m_pcaCards[0]->GetLargeWidth()*5+16):(m_phHand->m_pcaCards[0]->GetSmallWidth()*5+4)),
			 ppt->y+20+(bLarge?(m_phHand->m_pcaCards[0]->GetLargeHeight()):(m_phHand->m_pcaCards[0]->GetSmallHeight())));

	ppnOld=pDC->SelectObject(&pn);
	
	CString str="";
	Eval(str);

	if(str.GetLength())
	{
		pDC->RoundRect(rc,pt);
		pDC->SelectObject(ppnOld);

		rc.DeflateRect(1,1,1,1);	
		pDC->SetBkMode(TRANSPARENT);
		pDC->DrawText(str, rc, DT_VCENTER|DT_CENTER);
	}
}


CGameDucesWild::CGameDucesWild(CHand* phHand/*=NULL*/)
:CGame(phHand)
{
	m_phHand=phHand;
	if(m_phHand)
		m_uiValue=Eval(m_strName);
}

UINT CGameDucesWild::Eval(CString& strName)
{
	int aiSuitCount[5];
	int aiValueCount[15];
	int iPay;
	int i;
	int iTopPay;
	CString strTopName;

		
	// count the cards 
	memset(aiSuitCount,0,sizeof(int)*5);
	memset(aiValueCount,0,sizeof(int)*15);
	iPay=0;
	for(i=0;i<5;i++)
	{
		if((*m_phHand)[i]->GetValue() != 2)
		{
			aiSuitCount[(*m_phHand)[i]->GetSuit()/100]++;
		}
		aiValueCount[(*m_phHand)[i]->GetValue()]++;
	}

	// first check to see if we have 4 wild cards
	// 4 wilds are better than 5 of a kind

	// 4 wild = 200
	if(aiValueCount[2] == 4)
	{
		iPay=200;
		strName = "4 Wild";
		return iPay;
	}

	// don't even think of recursion!

	// if there are 2's in the hand, return the last value 
	// calculated above. It will be higher than anything you can calculate below

	
	// 2's are wild
	// I'll try to figure that out later

	// Royal Flush = 250
	// w/ wild = 20
	if(((aiSuitCount[1] + aiValueCount[2]) == 5 ||  // is it a flush with wilds
	    (aiSuitCount[2] + aiValueCount[2]) == 5 ||
	    (aiSuitCount[3] + aiValueCount[2]) == 5 ||
	    (aiSuitCount[4] + aiValueCount[2]) == 5) && 
	   (aiValueCount[10] <= 1 && // does it have 1 or 0 of each 10-A
	    aiValueCount[11] <= 1 &&
		aiValueCount[12] <= 1 &&
		aiValueCount[13] <= 1 &&
		aiValueCount[14] <= 1) &&
	   (aiValueCount[10] +  // is there a 2 to make up for each missing 10-A card 
	    aiValueCount[11] +
		aiValueCount[12] +
		aiValueCount[13] +
		aiValueCount[14]  +
		aiValueCount[2] == 5))
	{
		strName = "Royal Flush";
		iPay=250;
		if(aiValueCount[2])
		{
			strName = "Royal Flush w/2's";

			iPay=25; // take a bit off because wilds were used to make the royal flush
		}
		return iPay;
	}

	// Straight Flush = 9

	// Straight = 2
	// 5 consecutive cards 2-K
	for(i=3;i<=(13-4);i++)
	{
		if((aiValueCount[i] <= 1&&    // are there 5 cards in a row 
		    aiValueCount[i+1] <= 1 &&
		    aiValueCount[i+2] <= 1 &&
		    aiValueCount[i+3] <= 1 &&
		    aiValueCount[i+4] <= 1) &&
		   (aiValueCount[i] +   // or 1 each with a 2 to make up for the missing bits
		    aiValueCount[i+1] +
		    aiValueCount[i+2] +
		    aiValueCount[i+3] +
		    aiValueCount[i+4] +
		    aiValueCount[2] == 5))
		{
			strName = "Straight";
			iPay=2;
		}
	}
	// special case or 10-A If only they were not all the same suit 
	if((aiValueCount[10] <= 1  &&
	    aiValueCount[11] <= 1  &&
	    aiValueCount[12] <= 1  &&
	    aiValueCount[13] <= 1  &&
	    aiValueCount[14]  <= 1 ) &&
	   (aiValueCount[10] +   // or 1 each with a 2 to make up for the missing bits
		aiValueCount[11] +
		aiValueCount[12] +
		aiValueCount[13] +
		aiValueCount[14] +
		aiValueCount[2] == 5))
	{
		strName = "Straight";
		iPay=2;
	}

	// Flush =2
	if((aiSuitCount[1] + aiValueCount[2] == 5 ||
	    aiSuitCount[2] + aiValueCount[2] == 5 ||
	    aiSuitCount[3] + aiValueCount[2] == 5 ||
	    aiSuitCount[4] + aiValueCount[2] == 5))
	{
		strName = "Flush";
		iPay+=2;
	}

	// catches Flush, Straight, and Straight Flush
	// no need to continue evaluating

	if(iPay)
	{
		// upgrade payout for straight flush
		if(iPay==4)
		{
			strName = "Straight Flush";
			iPay=9;
		}
		//return iPay;
	}

	iTopPay=iPay;
	strTopName= strName;

	// 5 of a kind = 15 (only used when 2's are wild)
	for(i=3;i<=14;i++)
	{
		if(aiValueCount[i] + aiValueCount[2] == 5)
		{
			strName = "5 of a Kind";
			iPay=15;
			return iPay;
		}
	}
	// 4 of a kind = 5
	for(i=3;i<=14;i++)
	{
		if(aiValueCount[i] + aiValueCount[2] == 4)
		{
			strName = "4 of a Kind";
			iPay=5;

			if(iTopPay > iPay)
			{
				iPay = iTopPay;
				strName = strTopName;
			}
			return iPay;
		}
	}

	// Full House = 3
	// 3 of a kind = 1
	// a pair is really 1 and 3of is really 3 but if the pay is <=2 then kill it
	for(i=3;i<=14;i++)
	{
		if(aiValueCount[i] + aiValueCount[2] == 3)
		{
			strName = "3 of a Kind";
			iPay=3; // 3 of a kind only pays 1 but, we need something to diferentiate a full house from 2 pair
			        // a value of thee will be downgraded to one later.
			break;
		}
	}

	// pair has no value, except if there are two pair and a wild
	// or there is a pair and a three of a kind
	for(i=3;i<=14;i++)
	{
		if(aiValueCount[i] == 2) // no need to check for wilds here, because a pair by itself has no value
		{
			iPay+=1;
		}
	}

	// if we come out of this function with 4 for a 3 of a kind and a pair, then it is a full house

	// this means we got just one or two pair, so toss it
	if(iPay <= 2)
	{
		strName = "";
		iPay=0;
	}

	//that means we got a natual 3 of a kind
	if(iPay == 3)
		iPay=1;

	// upgrade payout for full house
	// XX2YY =5 but is a full house, XXXYY is a full house too, but only =4
	if(iPay == 5 || (iPay == 4 && !aiValueCount[2]))
	{
		strName = "Full House";
		iPay=3;
	}
	// downgrade payout for 3 of a kind w/ wild. XX2AB will show up a a 3 of a kind and a pair 
	else if(iPay == 3 || (iPay == 4 && aiValueCount[2]))
	{
		strName = "3 of a Kind";
		iPay=1;
	}

	if(iTopPay > iPay)
	{
		iPay = iTopPay;
		strName = strTopName;
	}
	return iPay;
}



CGameJackOrBetter::CGameJackOrBetter(CHand* phHand/*=NULL*/)
:CGame(phHand)
{
	m_phHand=phHand;
	if(m_phHand)
		m_uiValue=Eval(m_strName);
}

UINT CGameJackOrBetter::Eval(CString& strName)
{
	int aiSuitCount[5];
	int aiValueCount[15];
	int iPay;
	int i;
	int iJCount;

		
	// count the cards 
	memset(aiSuitCount,0,sizeof(int)*5);
	memset(aiValueCount,0,sizeof(int)*15);
	iPay=0;
	for(i=0;i<5;i++)
	{
		aiSuitCount[(*m_phHand)[i]->GetSuit()/100]++;
		aiValueCount[(*m_phHand)[i]->GetValue()]++;
	}

	// don't even think of recursion!

	// if there are 2's in the hand, return the last value 
	// calculated above. It will be higher than anything you can calculate below

	
	// 2's are wild
	// I'll try to figure that out later

	// Royal Flush = 250
	if((aiSuitCount[1] == 5 ||  // is it a flush with wilds
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5) && 
	   (aiValueCount[10] == 1 && // does it have 1 or 0 of each 10-A
	    aiValueCount[11] == 1 &&
		aiValueCount[12] == 1 &&
		aiValueCount[13] == 1 &&
		aiValueCount[14] == 1))
	{
		strName = "Royal Flush";
		iPay=250;

		return iPay;
	}

	// Straight Flush = 50

	// Straight = 4
	// 5 consecutive cards 2-K
	for(i=2;i<=(13-4);i++)
	{
		if((aiValueCount[i] == 1&&    // are there 5 cards in a row 
		    aiValueCount[i+1] == 1 &&
		    aiValueCount[i+2] == 1 &&
		    aiValueCount[i+3] == 1 &&
		    aiValueCount[i+4] == 1))
		{
			strName = "Straight";
			iPay=4;
		}
	}
	// special case or 10-A If only they were not all the same suit 
	if((aiValueCount[10] == 1  &&
	    aiValueCount[11] == 1  &&
	    aiValueCount[12] == 1  &&
	    aiValueCount[13] == 1  &&
	    aiValueCount[14]  == 1 ))
	{
		strName = "Straight";
		iPay=4;
	}

	// Flush =6
	if((aiSuitCount[1] == 5 ||
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5))
	{
		strName = "Flush";
		iPay+=6;
	}

	// catches Flush, Straight, and Straight Flush
	// no need to continue evaluating

	if(iPay)
	{
		// upgrade payout for straight flush
		if(iPay==10)
		{
			strName = "Straight Flush";
			iPay=50;
		}
		return iPay;
	}

	// 4 of a kind = 25
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 4)
		{
			strName = "4 of a Kind";
			iPay=25;

			return iPay;
		}
	}

	// Full House = 9
	// 3 of a kind = 3

	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 3)
		{
			strName = "3 of a Kind";
			iPay=3; 

			break;
		}
	}

	// pair has no value, except if there are two pair
	// or there is a pair and a three of a kind
	// or the pair is J or better
	iJCount=0;
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 2) // no need to check for wilds here, because a pair by itself has no value
		{
			if(i >= 11)
				iJCount++;
			iPay+=1;
		}
	}

	// if we come out of this function with 3 for a 3 of a kind and 1 for a pair, then it is a full house

	// this means we got just one pair lower than J's, so toss it
	if(iPay < 2 && iJCount < 1)
	{
		strName = "";
		iPay=0;
	}

	//that means we got a 3 of a kind
	if(iPay == 1)
	{
		strName = "Pair";
		iPay=1;
	}

	//that means we got a 3 of a kind
	if(iPay == 2)
	{
		strName = "2 Pair";
		iPay=2;
	}

	//that means we got a 3 of a kind
	if(iPay == 3)
	{
		strName = "3 of a Kind";
		iPay=3;
	}

	//that means we got a full house
	if(iPay == 4)
	{
		strName = "Full House";
		iPay=9;
	}

	return iPay;
}

CGameBonus::CGameBonus(CHand* phHand/*=NULL*/)
:CGame(phHand)
{
	m_phHand=phHand;
	if(m_phHand)
		m_uiValue=Eval(m_strName);
}

UINT CGameBonus::Eval(CString& strName)
{
	int aiSuitCount[5];
	int aiValueCount[15];
	int iPay;
	int i;
	int iJCount;

		
	// count the cards 
	memset(aiSuitCount,0,sizeof(int)*5);
	memset(aiValueCount,0,sizeof(int)*15);
	iPay=0;
	for(i=0;i<5;i++)
	{
		aiSuitCount[(*m_phHand)[i]->GetSuit()/100]++;
		aiValueCount[(*m_phHand)[i]->GetValue()]++;
	}

	// don't even think of recursion!

	// if there are 2's in the hand, return the last value 
	// calculated above. It will be higher than anything you can calculate below

	
	// Royal Flush = 250
	if((aiSuitCount[1] == 5 ||  // is it a flush with wilds
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5) && 
	   (aiValueCount[10] == 1 && // does it have 1 or 0 of each 10-A
	    aiValueCount[11] == 1 &&
		aiValueCount[12] == 1 &&
		aiValueCount[13] == 1 &&
		aiValueCount[14] == 1))
	{
		strName = "Royal Flush";
		iPay=250;

		return iPay;
	}

	// Straight Flush = 50

	// Straight = 4
	// 5 consecutive cards 2-K
	for(i=2;i<=(13-4);i++)
	{
		if((aiValueCount[i] == 1&&    // are there 5 cards in a row 
		    aiValueCount[i+1] == 1 &&
		    aiValueCount[i+2] == 1 &&
		    aiValueCount[i+3] == 1 &&
		    aiValueCount[i+4] == 1))
		{
			strName = "Straight";
			iPay=4;
		}
	}
	// special case or 10-A If only they were not all the same suit 
	if((aiValueCount[10] == 1  &&
	    aiValueCount[11] == 1  &&
	    aiValueCount[12] == 1  &&
	    aiValueCount[13] == 1  &&
	    aiValueCount[14]  == 1 ))
	{
		strName = "Straight";
		iPay=4;
	}

	// Flush =5
	if((aiSuitCount[1] == 5 ||
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5))
	{
		strName = "Flush";
		iPay+=5;
	}

	// catches Flush, Straight, and Straight Flush
	// no need to continue evaluating

	if(iPay)
	{
		// upgrade payout for straight flush
		if(iPay==9)
		{
			strName = "Straight Flush";
			iPay=50;
		}
		return iPay;
	}

	// 4 of a kind = 25
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 4)
		{
			if(i == 14)
			{
				strName = "4 Aces";
				iPay=80;
			}
			else if(i >= 2 && i <= 4)
			{
				strName = "4 of a Kind (2,3,4)";
				iPay=40;
			}
			else if(i >= 5 && i <= 13)
			{
				strName = "4 of a Kind (5-K)";
				iPay=25;
			}

			return iPay;
		}
	}

	// Full House = 8
	// 3 of a kind = 3

	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 3)
		{
			strName = "3 of a Kind";
			iPay=3; 

			break;
		}
	}

	// pair has no value, except if there are two pair
	// or there is a pair and a three of a kind
	// or the pair is J or better
	iJCount=0;
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 2) // no need to check for wilds here, because a pair by itself has no value
		{
			if(i >= 11)
				iJCount++;
			iPay+=1;
		}
	}

	// if we come out of this function with 3 for a 3 of a kind and 1 for a pair, then it is a full house

	// this means we got just one pair lower than J's, so toss it
	if(iPay < 2 && iJCount < 1)
	{
		strName = "";
		iPay=0;
	}

	//that means we got a 3 of a kind
	if(iPay == 1)
	{
		strName = "Pair";
		iPay=1;
	}

	//that means we got a 3 of a kind
	if(iPay == 2)
	{
		strName = "2 Pair";
		iPay=2;
	}

	//that means we got a 3 of a kind
	if(iPay == 3)
	{
		strName = "3 of a Kind";
		iPay=3;
	}

	//that means we got a full house
	if(iPay == 4)
	{
		strName = "Full House";
		iPay=8;
	}

	return iPay;
}


CGameDoubleBonus::CGameDoubleBonus(CHand* phHand/*=NULL*/)
:CGame(phHand)
{
	m_phHand=phHand;
	if(m_phHand)
		m_uiValue=Eval(m_strName);
}

UINT CGameDoubleBonus::Eval(CString& strName)
{
	int aiSuitCount[5];
	int aiValueCount[15];
	int iPay;
	int i;
	int iJCount;

		
	// count the cards 
	memset(aiSuitCount,0,sizeof(int)*5);
	memset(aiValueCount,0,sizeof(int)*15);
	iPay=0;
	for(i=0;i<5;i++)
	{
		aiSuitCount[(*m_phHand)[i]->GetSuit()/100]++;
		aiValueCount[(*m_phHand)[i]->GetValue()]++;
	}

	// Royal Flush = 250
	if((aiSuitCount[1] == 5 ||  // is it a flush with wilds
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5) && 
	   (aiValueCount[10] == 1 && // does it have 1 or 0 of each 10-A
	    aiValueCount[11] == 1 &&
		aiValueCount[12] == 1 &&
		aiValueCount[13] == 1 &&
		aiValueCount[14] == 1))
	{
		strName = "Royal Flush";
		iPay=250;

		return iPay;
	}

	// Straight Flush = 50

	// Straight = 5
	// 5 consecutive cards 2-K
	for(i=2;i<=(13-4);i++)
	{
		if((aiValueCount[i] == 1&&    // are there 5 cards in a row 
		    aiValueCount[i+1] == 1 &&
		    aiValueCount[i+2] == 1 &&
		    aiValueCount[i+3] == 1 &&
		    aiValueCount[i+4] == 1))
		{
			strName = "Straight";
			iPay=5;
		}
	}
	// special case or 10-A If only they were not all the same suit 
	if((aiValueCount[10] == 1  &&
	    aiValueCount[11] == 1  &&
	    aiValueCount[12] == 1  &&
	    aiValueCount[13] == 1  &&
	    aiValueCount[14]  == 1 ))
	{
		strName = "Straight";
		iPay=5;
	}

	// Flush =7
	if((aiSuitCount[1] == 5 ||
	    aiSuitCount[2] == 5 ||
	    aiSuitCount[3] == 5 ||
	    aiSuitCount[4] == 5))
	{
		strName = "Flush";
		iPay+=7;
	}

	// catches Flush, Straight, and Straight Flush
	// no need to continue evaluating

	if(iPay)
	{
		// upgrade payout for straight flush
		if(iPay==12)
		{
			strName = "Straight Flush";
			iPay=50;
		}
		return iPay;
	}

	// 4 of a kind = 25
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 4)
		{
			if(i == 14)
			{
				strName = "4 Aces";
				iPay=160;
			}
			else if(i >= 2 && i <= 4)
			{
				strName = "4 of a Kind (2,3,4)";
				iPay=80;
			}
			else if(i >= 5 && i <= 13)
			{
				strName = "4 of a Kind (5-K)";
				iPay=50;
			}

			return iPay;
		}
	}

	// Full House = 10
	// 3 of a kind = 3

	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 3)
		{
			strName = "3 of a Kind";
			iPay=3; 

			break;
		}
	}

	// pair has no value, except if there are two pair
	// or there is a pair and a three of a kind
	// or the pair is J or better
	iJCount=0;
	for(i=2;i<=14;i++)
	{
		if(aiValueCount[i] == 2) // no need to check for wilds here, because a pair by itself has no value
		{
			if(i >= 11)
				iJCount++;
			iPay+=1;
		}
	}

	// if we come out of this function with 3 for a 3 of a kind and 1 for a pair, then it is a full house

	// this means we got just one pair lower than J's, so toss it
	if(iPay < 2 && iJCount < 1)
	{
		strName = "";
		iPay=0;
	}

	//that means we got a 3 of a kind
	if(iPay == 1)
	{
		strName = "Pair";
		iPay=1;
	}

	//that means we got a 3 of a kind
	if(iPay == 2)
	{
		strName = "2 Pair";
		iPay=1;
	}

	//that means we got a 3 of a kind
	if(iPay == 3)
	{
		strName = "3 of a Kind";
		iPay=3;
	}

	//that means we got a full house
	if(iPay == 4)
	{
		strName = "Full House";
		iPay=10;
	}

	return iPay;
}
