#ifndef _INC_CARD_H_
#define _INC_CARD_H_


#define CLUB    (100)
#define DIAMOND (200)
#define HEART   (300)
#define SPADE   (400)

#define ACE    (14)
#define KING   (13)
#define QUEEN  (12)
#define JACK   (11)

class CCard : public CObject
{
public:
    DECLARE_DYNAMIC(CCard) 
	CCard(UINT uiSuit=NULL, UINT uiValue=NULL, UINT uiLargeFace=NULL, UINT uiSmallFace=NULL);
	~CCard();
	
	void Render(CDC* pDC, POINT* ppt, BOOL bLarge=FALSE);
	
	UINT GetValue();
	UINT GetSuit();

	void SetValue(UINT uiValue);
	void SetSuit(UINT uiSuit);

	UINT GetSmallHeight();
	UINT GetSmallWidth();
	UINT GetLargeHeight();
	UINT GetLargeWidth();

protected:

	CBitmap m_bmpLargeFace;
	CBitmap m_bmpSmallFace;
	BOOL m_bLargeFaceLoaded;
	BOOL m_bSmallFaceLoaded;
	UINT m_uiSuit;
	UINT m_uiValue;
};

class CDeck : public CObject
{
public:
    DECLARE_DYNAMIC(CDeck) 
	CDeck(CArray<CCard*,CCard*>* ppcaCards=NULL);
	~CDeck();

	void Add(CCard* pCard);
	void Add(CArray<CCard*,CCard*>* ppcaCards);
	void Shuffle();
	void Reset();
	CCard* Deal();
	UINT GetCount();
	UINT GetRemainingCount();
	void DestroyCards();
	void CreateSubDeck();
	CCard* DealSubDeck();
	void SetBacks(CCard *pCard);
	CArray<CCard*,CCard*>* GetBacks();


protected:
	CArray<CCard*,CCard*>  m_pcaCards;
	CArray<CCard*,CCard*>  m_pcaSubDeck;
	CArray<CCard*,CCard*>  m_pcaDelt;
	CArray<CCard*,CCard*>  m_pcaBacks;

};

class CHand : public CObject
{
public:
    DECLARE_DYNAMIC(CHand) 
	CHand(CArray<CCard*,CCard*>* ppcaCards=NULL);
	~CHand();

	CCard* GetAt(int iIndex);
	void SetAt(int iIndex, CCard* pcCard);
	void SetCards(CArray<CCard*,CCard*>* ppcaCards);
	int Add(CCard* pcCard);
	void Render(CDC* pDC, POINT* ppt, BOOL bLarge=FALSE);
	UINT GetCount();
	UINT GetSmallHeight();
	UINT GetSmallWidth();
	UINT GetLargeHeight();
	UINT GetLargeWidth();

	CCard* operator [](int iIndex);
	CArray<CCard*,CCard*>  m_pcaCards;
};

class CGame : public CObject
{
public:
    DECLARE_DYNAMIC(CGame) 
	CGame(CHand* phHand=NULL);
	virtual ~CGame();

	void SetHand(CHand* phHand);
	CHand* GetHand();
	UINT GetValue();
	LPCTSTR GetName();
	void Render(CDC* pDC, POINT* ppt, BOOL bLarge=FALSE);
	
	virtual UINT Eval(CString& strName);

protected:
	CHand* m_phHand;
	CString m_strName;
	UINT m_uiValue;
};

class CGameDucesWild  : public CGame
{
public:
    DECLARE_DYNAMIC(CGameDucesWild) 
	CGameDucesWild(CHand* phHand=NULL);

protected:
	virtual UINT Eval(CString& strName);
};


class CGameJackOrBetter : public CGame
{
public:
    DECLARE_DYNAMIC(CGameJackOrBetter) 
	CGameJackOrBetter(CHand* phHand=NULL);

protected:
	virtual UINT Eval(CString& strName);
};

class CGameBonus : public CGame
{
public:
    DECLARE_DYNAMIC(CGameBonus) 
	CGameBonus(CHand* phHand=NULL);

protected:
	virtual UINT Eval(CString& strName);
};

class CGameDoubleBonus : public CGame
{
public:
    DECLARE_DYNAMIC(CGameDoubleBonus) 
	CGameDoubleBonus(CHand* phHand=NULL);

protected:
	virtual UINT Eval(CString& strName);
};

#endif

