// PokerIIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PokerII.h"
#include "PokerIIDlg.h"
#include "card.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPokerIIDlg dialog

CPokerIIDlg::CPokerIIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPokerIIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPokerIIDlg)
	m_iBet = 0;
	m_iHands = 0;
	m_iBank = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPokerIIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPokerIIDlg)
	DDX_Control(pDX, IDC_DOUBLEBONUS, m_cbDoubleBonus);
	DDX_Control(pDX, IDC_BONUS, m_cbBonus);
	DDX_Control(pDX, IDC_JACKS, m_cbJacks);
	DDX_Control(pDX, IDC_DUCES, m_cbDuces);
	DDX_Control(pDX, IDC_PAYOUT, m_lPayOut);
	DDX_Control(pDX, IDC_SPINHANDS, m_spinHands);
	DDX_Control(pDX, IDC_SPINBET, m_spinBet);
	DDX_Control(pDX, IDC_DRAW, m_btnDraw);
	DDX_Control(pDX, IDC_DEAL, m_btnDeal);
	DDX_Control(pDX, IDC_HOLD4, m_btnHold4);
	DDX_Control(pDX, IDC_HOLD3, m_btnHold3);
	DDX_Control(pDX, IDC_HOLD2, m_btnHold2);
	DDX_Control(pDX, IDC_HOLD1, m_btnHold1);
	DDX_Control(pDX, IDC_HOLD0, m_btnHold0);
	DDX_Text(pDX, IDC_BET, m_iBet);
	DDV_MinMaxInt(pDX, m_iBet, 1, 5);
	DDX_Text(pDX, IDC_HANDS, m_iHands);
	DDV_MinMaxInt(pDX, m_iHands, 1, 50);
	DDX_Text(pDX, IDC_BANK, m_iBank);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPokerIIDlg, CDialog)
	//{{AFX_MSG_MAP(CPokerIIDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_DEAL, OnDeal)
	ON_BN_CLICKED(IDC_HOLD0, OnHold0)
	ON_BN_CLICKED(IDC_HOLD1, OnHold1)
	ON_BN_CLICKED(IDC_HOLD2, OnHold2)
	ON_BN_CLICKED(IDC_HOLD3, OnHold3)
	ON_BN_CLICKED(IDC_HOLD4, OnHold4)
	ON_BN_CLICKED(IDC_DRAW, OnDraw)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPINBET, OnDeltaposSpinbet)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPINHANDS, OnDeltaposSpinhands)
	ON_BN_CLICKED(IDC_DUCES, OnDuces)
	ON_BN_CLICKED(IDC_JACKS, OnJacks)
	ON_BN_CLICKED(IDC_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_BONUS, OnBonus)
	ON_BN_CLICKED(IDC_DOUBLEBONUS, OnDoublebonus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPokerIIDlg message handlers

BOOL CPokerIIDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	int j;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_iBet = 1;
	m_iHands=50;
	m_iBank=1000;
	UpdateData(FALSE);

	m_spinBet.SetRange(1,5);
	m_spinBet.SetPos(1);
	m_spinHands.SetRange(1,50);
	m_spinHands.SetPos(50);

	m_iGame=JACKS;
	m_cbJacks.SetCheck(1);
	m_cbBonus.SetCheck(0);
	m_cbDuces.SetCheck(0);

	// TODO: Add extra initialization here

	// create Cards
		// create local card array
	CArray<CCard*,CCard*> pcaCards;
	pcaCards.Add(new CCard(SPADE,2,IDB_L_S2,IDB_S_S2));
	pcaCards.Add(new CCard(SPADE,3,IDB_L_S3,IDB_S_S3));
	pcaCards.Add(new CCard(SPADE,4,IDB_L_S4,IDB_S_S4));
	pcaCards.Add(new CCard(SPADE,5,IDB_L_S5,IDB_S_S5));
	pcaCards.Add(new CCard(SPADE,6,IDB_L_S6,IDB_S_S6));
	pcaCards.Add(new CCard(SPADE,7,IDB_L_S7,IDB_S_S7));
	pcaCards.Add(new CCard(SPADE,8,IDB_L_S8,IDB_S_S8));
	pcaCards.Add(new CCard(SPADE,9,IDB_L_S9,IDB_S_S9));
	pcaCards.Add(new CCard(SPADE,10,IDB_L_S10,IDB_S_S10));
	pcaCards.Add(new CCard(SPADE,JACK,IDB_L_SJ,IDB_S_SJ));
	pcaCards.Add(new CCard(SPADE,QUEEN,IDB_L_SQ,IDB_S_SQ));
	pcaCards.Add(new CCard(SPADE,KING,IDB_L_SK,IDB_S_SK));
	pcaCards.Add(new CCard(SPADE,ACE,IDB_L_SA,IDB_S_SA));

	pcaCards.Add(new CCard(HEART,2,IDB_L_H2,IDB_S_H2));
	pcaCards.Add(new CCard(HEART,3,IDB_L_H3,IDB_S_H3));
	pcaCards.Add(new CCard(HEART,4,IDB_L_H4,IDB_S_H4));
	pcaCards.Add(new CCard(HEART,5,IDB_L_H5,IDB_S_H5));
	pcaCards.Add(new CCard(HEART,6,IDB_L_H6,IDB_S_H6));
	pcaCards.Add(new CCard(HEART,7,IDB_L_H7,IDB_S_H7));
	pcaCards.Add(new CCard(HEART,8,IDB_L_H8,IDB_S_H8));
	pcaCards.Add(new CCard(HEART,9,IDB_L_H9,IDB_S_H9));
	pcaCards.Add(new CCard(HEART,10,IDB_L_H10,IDB_S_H10));
	pcaCards.Add(new CCard(HEART,JACK,IDB_L_HJ,IDB_S_HJ));
	pcaCards.Add(new CCard(HEART,QUEEN,IDB_L_HQ,IDB_S_HQ));
	pcaCards.Add(new CCard(HEART,KING,IDB_L_HK,IDB_S_HK));
	pcaCards.Add(new CCard(HEART,ACE,IDB_L_HA,IDB_S_HA));

	pcaCards.Add(new CCard(CLUB,2,IDB_L_C2,IDB_S_C2));
	pcaCards.Add(new CCard(CLUB,3,IDB_L_C3,IDB_S_C3));
	pcaCards.Add(new CCard(CLUB,4,IDB_L_C4,IDB_S_C4));
	pcaCards.Add(new CCard(CLUB,5,IDB_L_C5,IDB_S_C5));
	pcaCards.Add(new CCard(CLUB,6,IDB_L_C6,IDB_S_C6));
	pcaCards.Add(new CCard(CLUB,7,IDB_L_C7,IDB_S_C7));
	pcaCards.Add(new CCard(CLUB,8,IDB_L_C8,IDB_S_C8));
	pcaCards.Add(new CCard(CLUB,9,IDB_L_C9,IDB_S_C9));
	pcaCards.Add(new CCard(CLUB,10,IDB_L_C10,IDB_S_C10));
	pcaCards.Add(new CCard(CLUB,JACK,IDB_L_CJ,IDB_S_CJ));
	pcaCards.Add(new CCard(CLUB,QUEEN,IDB_L_CQ,IDB_S_CQ));
	pcaCards.Add(new CCard(CLUB,KING,IDB_L_CK,IDB_S_CK));
	pcaCards.Add(new CCard(CLUB,ACE,IDB_L_CA,IDB_S_CA));

	pcaCards.Add(new CCard(DIAMOND,2,IDB_L_D2,IDB_S_D2));
	pcaCards.Add(new CCard(DIAMOND,3,IDB_L_D3,IDB_S_D3));
	pcaCards.Add(new CCard(DIAMOND,4,IDB_L_D4,IDB_S_D4));
	pcaCards.Add(new CCard(DIAMOND,5,IDB_L_D5,IDB_S_D5));
	pcaCards.Add(new CCard(DIAMOND,6,IDB_L_D6,IDB_S_D6));
	pcaCards.Add(new CCard(DIAMOND,7,IDB_L_D7,IDB_S_D7));
	pcaCards.Add(new CCard(DIAMOND,8,IDB_L_D8,IDB_S_D8));
	pcaCards.Add(new CCard(DIAMOND,9,IDB_L_D9,IDB_S_D9));
	pcaCards.Add(new CCard(DIAMOND,10,IDB_L_D10,IDB_S_D10));
	pcaCards.Add(new CCard(DIAMOND,JACK,IDB_L_DJ,IDB_S_DJ));
	pcaCards.Add(new CCard(DIAMOND,QUEEN,IDB_L_DQ,IDB_S_DQ));
	pcaCards.Add(new CCard(DIAMOND,KING,IDB_L_DK,IDB_S_DK));
	pcaCards.Add(new CCard(DIAMOND,ACE,IDB_L_DA,IDB_S_DA));

	// create Deck
		// transfer local card array to deck
	m_dMasterDeck.Add(&pcaCards);


	// remove local card array
	pcaCards.RemoveAll();
	// does not destroy the cards in the array.

	m_dMasterDeck.SetBacks(new CCard(0,0,IDB_LARGE,IDB_SMALL));
	for(j=0;j<50;j++)
	{
		m_hHand[j].SetCards(m_dMasterDeck.GetBacks());
	}

	m_bHold[0]=m_bHold[1]=m_bHold[2]=m_bHold[3]=m_bHold[4]=FALSE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPokerIIDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPokerIIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		int i,j,k;
		CGame* game;
		CPaintDC dc(this); // device context for painting

		// call hand.render() in here to draw hand

		CPoint pt(5,5);

		for(i=1,k=1;i<=7;i++)
		{
			for(j=1;j<=7;j++,k++)
			{
				pt.x=5+(0+(m_hHand[i*j].GetSmallWidth()+6)*(i-1));
				pt.y=5+(0+(m_hHand[i*j].GetSmallHeight()+25)*(j-1));
				m_hHand[k].Render(&dc,&pt,FALSE);

				if(m_iGame==DUCES)
					game= new CGameDucesWild(&m_hHand[k]);
				else if(m_iGame==JACKS)
					game= new CGameJackOrBetter(&m_hHand[k]);
				else if(m_iGame==BONUS)
					game= new CGameBonus(&m_hHand[k]);
				else if(m_iGame==DOUBLEBONUS)
					game= new CGameDoubleBonus(&m_hHand[k]);


				game->Render(&dc,&pt,FALSE);

				delete game;
			}
		}
		pt.x=10;
		pt.y=5+(0+(m_hHand[0].GetSmallHeight()+19)*(j));
		m_hHand[0].Render(&dc,&pt,TRUE);


		if(m_iGame==DUCES)
			game = new CGameDucesWild(&m_hHand[0]);
		else if(m_iGame==JACKS)
			game = new CGameJackOrBetter(&m_hHand[0]);
		else if(m_iGame==BONUS)
			game = new CGameBonus(&m_hHand[0]);
		else if(m_iGame==DOUBLEBONUS)
			game = new CGameDoubleBonus(&m_hHand[0]);


		game->Render(&dc,&pt,TRUE);
		delete game;


		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPokerIIDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CPokerIIDlg::OnOK() 
{
}

void CPokerIIDlg::OnCancel() 
{
	m_dMasterDeck.DestroyCards();
	CDialog::OnCancel();
}

void CPokerIIDlg::OnDeal() 
{
	int i,j;

	m_msiPayoutMap.RemoveAll();
	m_msiScoreMap.RemoveAll();
	m_lPayOut.ResetContent();


	m_btnHold0.EnableWindow(TRUE);
	m_btnHold1.EnableWindow(TRUE);
	m_btnHold2.EnableWindow(TRUE);
	m_btnHold3.EnableWindow(TRUE);
	m_btnHold4.EnableWindow(TRUE);

	m_spinBet.EnableWindow(FALSE);
	m_spinHands.EnableWindow(FALSE);
	UpdateData(TRUE);

	m_iBank-=(m_iBet*m_iHands);
	UpdateData(FALSE);

	for(j=0;j<50;j++)
	{
		m_hHand[j].SetCards(m_dMasterDeck.GetBacks());
	}
	Invalidate();

	m_dMasterDeck.Reset();
	m_dMasterDeck.Shuffle();

	for(i=0;i<5;i++)
	{
		CCard* pCard = m_dMasterDeck.Deal();
		m_hHand[0].SetAt(i,pCard);
	}

	m_bHold[0]=FALSE;
	m_btnHold0.SetWindowText("");
	m_bHold[1]=FALSE;
	m_btnHold1.SetWindowText("");
	m_bHold[2]=FALSE;
	m_btnHold2.SetWindowText("");
	m_bHold[3]=FALSE;
	m_btnHold3.SetWindowText("");
	m_bHold[4]=FALSE;
	m_btnHold4.SetWindowText("");

	m_btnDeal.EnableWindow(FALSE);
	m_btnDraw.EnableWindow(TRUE);
	m_cbJacks.EnableWindow(FALSE);
	m_cbBonus.EnableWindow(FALSE);
	m_cbDoubleBonus.EnableWindow(FALSE);
	m_cbDuces.EnableWindow(FALSE);
	Invalidate();

}

void CPokerIIDlg::OnHold0() 
{
	m_bHold[0]=!m_bHold[0];

	if(m_bHold[0])
		m_btnHold0.SetWindowText("Held");
	else
		m_btnHold0.SetWindowText("");
}

void CPokerIIDlg::OnHold1() 
{
	m_bHold[1]=!m_bHold[1];
	
	if(m_bHold[1])
		m_btnHold1.SetWindowText("Held");
	else
		m_btnHold1.SetWindowText("");
}

void CPokerIIDlg::OnHold2() 
{
	m_bHold[2]=!m_bHold[2];
	
	if(m_bHold[2])
		m_btnHold2.SetWindowText("Held");
	else
		m_btnHold2.SetWindowText("");
}

void CPokerIIDlg::OnHold3() 
{
	m_bHold[3]=!m_bHold[3];
	
	if(m_bHold[3])
		m_btnHold3.SetWindowText("Held");
	else
		m_btnHold3.SetWindowText("");
}

void CPokerIIDlg::OnHold4() 
{
	m_bHold[4]=!m_bHold[4];
	
	if(m_bHold[4])
		m_btnHold4.SetWindowText("Held");
	else
		m_btnHold4.SetWindowText("");
}

void CPokerIIDlg::OnDraw() 
{
	int i,j;
	int iValue=0;
	DWORD dwCount=0;
	DWORD dwValue=0;
	int iWin=0;

	m_btnHold0.EnableWindow(FALSE);
	m_btnHold1.EnableWindow(FALSE);
	m_btnHold2.EnableWindow(FALSE);
	m_btnHold3.EnableWindow(FALSE);
	m_btnHold4.EnableWindow(FALSE);


	for(j=0;j<m_iHands;j++)
	{
		m_dMasterDeck.Shuffle();
		m_dMasterDeck.CreateSubDeck();

		for(i=0;i<5;i++)
		{
			CCard* pCard = m_dMasterDeck.DealSubDeck();
			if(!m_bHold[i])
				m_hHand[j].SetAt(i,pCard);
			else
				m_hHand[j].SetAt(i,m_hHand[0][i]);	
		}
	}
	
	m_btnDeal.EnableWindow(TRUE);
	m_btnDraw.EnableWindow(FALSE);

	for(i=0;i<m_iHands;i++)
	{
		CGame* game;
		if(m_iGame==DUCES)
			game = new CGameDucesWild(&m_hHand[i]);
		else if(m_iGame==JACKS)
			game = new CGameJackOrBetter(&m_hHand[i]);
		else if(m_iGame==BONUS)
			game = new CGameBonus(&m_hHand[i]);
		else if(m_iGame==DOUBLEBONUS)
			game = new CGameDoubleBonus(&m_hHand[i]);

		iValue = game->GetValue()*m_iBet;
		iWin+=iValue;
		CString strName = game->GetName();
		if(strName.GetLength())
		{
			dwCount=0;
			m_msiPayoutMap.Lookup(strName,(void*&)dwCount);
			dwCount++;
			m_msiPayoutMap.SetAt(strName,(void*)dwCount);

			dwValue=0;
			m_msiScoreMap.Lookup(strName,(void*&)dwValue);
			dwValue+=iValue;
			m_msiScoreMap.SetAt(strName,(void*)dwValue);
		}

		delete game;
	}

	POSITION pos = m_msiPayoutMap.GetStartPosition();
	while(pos)
	{
		CString strKey;

		m_msiPayoutMap.GetNextAssoc(pos,strKey,(void*&)dwCount);
		m_msiScoreMap.Lookup(strKey,(void*&)iValue);

		CString strReadOut;
		strReadOut.Format("%s: %d@%dx%d= %d",(LPCSTR)strKey,dwCount,iValue/dwCount/m_iBet,m_iBet,iValue);
		m_lPayOut.AddString(strReadOut);
	}
		CString strReadOut;
		strReadOut.Format("Total: %d",iWin);
		m_lPayOut.AddString("==========");
		m_lPayOut.AddString(strReadOut);

	m_iBank+=iWin;
	if(m_iBank < m_iBet*m_iHands)
		m_btnDeal.EnableWindow(FALSE);


	UpdateData(FALSE);

	m_spinBet.EnableWindow(TRUE);
	m_spinHands.EnableWindow(TRUE);
	m_cbJacks.EnableWindow(TRUE);
	m_cbBonus.EnableWindow(TRUE);
	m_cbDoubleBonus.EnableWindow(TRUE);
	m_cbDuces.EnableWindow(TRUE);

	Invalidate();
}

void CPokerIIDlg::OnDeltaposSpinbet(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here

	m_iBet = pNMUpDown->iPos;
	UpdateData(FALSE);
	//UpdateData(TRUE);


	if(m_iBank >= (m_iHands * m_iBet))
	{
		m_btnDeal.EnableWindow(TRUE);
	}
	else
	{
		m_btnDeal.EnableWindow(FALSE);
	}
	
	*pResult = 0;
}

void CPokerIIDlg::OnDeltaposSpinhands(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	m_iHands = pNMUpDown->iPos;
	UpdateData(FALSE);
	//UpdateData(TRUE);

	if(m_iBank >= (m_iHands * m_iBet))
	{
		m_btnDeal.EnableWindow(TRUE);
	}
	else
	{
		m_btnDeal.EnableWindow(FALSE);
	}
	
	*pResult = 0;
}

void CPokerIIDlg::OnDuces() 
{
	m_iGame=DUCES;	
	m_cbDuces.SetCheck(1);
	m_cbJacks.SetCheck(0);
	m_cbBonus.SetCheck(0);
	m_cbDoubleBonus.SetCheck(0);
}

void CPokerIIDlg::OnJacks() 
{
	m_iGame=JACKS;	
	m_cbJacks.SetCheck(1);
	m_cbDuces.SetCheck(0);
	m_cbBonus.SetCheck(0);
	m_cbDoubleBonus.SetCheck(0);
}

void CPokerIIDlg::OnBonus() 
{
	m_iGame=BONUS;	
	m_cbBonus.SetCheck(1);
	m_cbDuces.SetCheck(0);
	m_cbJacks.SetCheck(0);
	m_cbDoubleBonus.SetCheck(0);
}

void CPokerIIDlg::OnDoublebonus() 
{
	m_iGame=DOUBLEBONUS;	
	m_cbDoubleBonus.SetCheck(1);
	m_cbDuces.SetCheck(0);
	m_cbJacks.SetCheck(0);
	m_cbBonus.SetCheck(0);
}

void CPokerIIDlg::OnAbout() 
{
	CAboutDlg dlg;
	dlg.DoModal();
}



LRESULT CPokerIIDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message == WM_CTLCOLORLISTBOX)
	{
		HBRUSH br;
		HDC hdc;

		br = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		hdc=(HDC)wParam;
		SetBkMode(hdc,TRANSPARENT);

		return (LRESULT)br;

	}

	return CDialog::WindowProc(message, wParam, lParam);
}
